<?php


namespace IZON\MVC\Interceptors;

use IZON\MVC\Config;
use IZON\MVC\HttpRequest;
use IZON\MVC\ModelAndView;
use IZON\MVC\URLDomain\URLDomain;

/**
 * Class URLDomainInterceptor
 * Sets current domain from request to global service UrlDomain.
 *
 * @package IZON\MVC\Interceptors
 */
class URLDomainInterceptor implements Interceptor {

    const CURRENT_DOMAIN_UID = '_currentDomainUID';

    /**
     * @var URLDomain
     */
    protected $urlDomain;

    /**
     * URLDomainInterceptor constructor.
     * @param URLDomain $urlDomain
     */
    public function __construct(URLDomain $urlDomain) {
        $this->urlDomain = $urlDomain;
    }


    public function afterCompletion(HttpRequest $request, $exception) {

    }

    public function postHandle(HttpRequest $request, ModelAndView $model) {
        $model->putParameter(self::CURRENT_DOMAIN_UID, $this->urlDomain->getDomainUID());
    }

    public function preHandle(HttpRequest $request) {
        $this->urlDomain->setDomainName($request->getDomain());
        $this->urlDomain->setDomainUID($request->getDomainUID());
        $this->urlDomain->setAppUID($this->getAppUid($request->getDomainUID()));
    }

    /**
     * @param $domainUID
     * @return string
     * @throws \Exception
     */
    protected function getAppUid($domainUID): string {
        $appConfig = Config::getValue('app.config');
        foreach($appConfig as $appUid => $domains) {
            if(array_key_exists($domainUID, $domains)) {
                return $appUid;
            }
        }
        throw new \Exception("No AppUID found for domainUID {$domainUID}");
    }

}
