<?php


namespace IZON\MVC\URLDomain;

/**
 * Class URLDomain
 * Holds current domain and domainUID.
 *
 * @package IZON\MVC\URLDomain
 */
class URLDomain {

    /**
     * @var string
     */
    protected $appUID;

    /**
     * @var string
     */
    protected $domainUID;

    /**
     * @var string
     */
    protected $domainName;

    /**
     * @return string
     */
    public function getDomainUID(): string {
        return $this->domainUID;
    }

    /**
     * @param string $domainUID
     */
    public function setDomainUID(string $domainUID): void {
        $this->domainUID = $domainUID;
    }

    /**
     * @return string
     */
    public function getDomainName(): string {
        return $this->domainName;
    }

    /**
     * @param string $domainName
     */
    public function setDomainName(string $domainName): void {
        $this->domainName = $domainName;
    }

    /**
     * @return string
     */
    public function getAppUID(): string {
        return $this->appUID;
    }

    /**
     * @param string $appUID
     */
    public function setAppUID(string $appUID): void {
        $this->appUID = $appUID;
    }

}
