<?php

namespace IZON\MVC\Exceptions\Handlers;

use Exception;

use \IZON\Logs\LogLevel;
use IZON\MVC\Controller;
use IZON\MVC\Controllers\SimpleErrorController;
use IZON\MVC\Exceptions\AccessForbiddenException;
use IZON\MVC\HttpRequest;
use IZON\MVC\Interceptors\CompatibleWrapperInterceptor;
use IZON\MVC\Messages\HttpRequestInterface;
use IZON\MVC\Interceptors\Interceptor;
use IZON\MVC\Interceptors\PreHandleResult;
use IZON\MVC\Messages\HttpResponseInterface;
use Throwable;

/**
 * Handles not accessable page request
 */
class AccessForbiddenExceptionHandler implements IAppExceptionHandler {

    /**
     * @var SimpleErrorController
     */
    protected $controller;
    /**
     * @var Interceptor[]
     */
    protected $interceptors = [];

    /**
     * AccessForbiddenExceptionHandler constructor.
     * @param SimpleErrorController $controller
     */
    public function __construct(SimpleErrorController $controller) {
        $this->controller = $controller;
    }

    /**
     * @param Interceptor[] $interceptors
     */
    public function setInterceptors(array $interceptors): void {
        $this->interceptors = [];
        foreach($interceptors as $interceptor) {
            if(is_subclass_of($interceptor, Interceptor::class)) {
                $interceptor = new CompatibleWrapperInterceptor($interceptor);
            }
            $this->interceptors[] = $interceptor;
        }
    }


    public function getLogLevel() {
        return LogLevel::WARN;
    }

    /***
     * @param AccessForbiddenException $exception
     * @param HttpRequestInterface $request
     * @throws Exception
     * @return \IZON\MVC\ModelAndView|NULL
     */
    public function handleException(Throwable $exception,  ?HttpRequestInterface $request, ?HttpResponseInterface $response) : ?HttpResponseInterface {
        if(empty($request)){
            throw new Exception(self::class . ' is not able to handle exception without HttpRequest object');
        }
        foreach ($this->interceptors as $interceptor) {
            $preHandleResult = $interceptor->preHandle($request);
            if ($preHandleResult instanceof PreHandleResult) {
                if($preHandleResult->isExternalRedirect() || $preHandleResult->isInternalRedirect()){

                }
            }
        }

        $response = $this->controller->execute($request, $response);

        foreach ($this->interceptors as $interceptor) {
            $response = $interceptor->postHandle($request, $response);
        }

        foreach($this->interceptors as $interceptor) {
            $response = $interceptor->afterCompletion($request, $response, null);
        }

        return $response;
    }

    public function isFor(Throwable $exception) {
        return $exception instanceof AccessForbiddenException;
    }
}
