<?php


namespace IZON\MVC\Interceptors;


use IZON\MVC\Messages\HttpRequestInterface;
use IZON\MVC\Messages\HttpResponseInterface;
use IZON\MVC\ModelAndView;


interface InterceptorInterface {

    /**
     * provadi se pred vyvolanim controlleru
     * muze vratit informace ktere mohou slouzit k presmerovani nebo dalsim akcim
     *
     * @param HttpRequestInterface $request
     * @return NULL|PreHandleResult default return value is null
     */
    public function preHandle(HttpRequestInterface $request): HttpRequestInterface;

    /**
     * provede se po vyvolani controlleru ale pred vyvolanim view<br /><br />
     *
     * @param HttpRequestInterface $request
     * @param HttpResponseInterface $response
     * @param ModelAndView $model
     */
    public function postHandle(HttpRequestInterface $request, HttpResponseInterface $response) : HttpResponseInterface;

    /**
     *
     * vyvolava se po volani view, slouzi predevsim k uklidu alokovanych zdroju atd.
     * @param HttpRequestInterface $request information about request passed to server
     * @param Exception $exception vyjimka pokud byla nejaka vyvolanna, jinak null
     * @return mixed
     */
    public function afterCompletion(HttpRequestInterface $request, HttpResponseInterface $response, $exception) : HttpResponseInterface;


}
