<?php


namespace IZON\MVC\Exceptions\Handlers;


use IZON\MVC\Controllers\SimpleErrorController;
use IZON\MVC\Interceptors\CompatibleWrapperInterceptor;
use IZON\MVC\Interceptors\Interceptor;

class ControllerChain {

    /**
     * @var SimpleErrorController
     */
    protected $controller;
    /**
     * @var array
     */
    protected $interceptors = [];

    /**
     * ControllerChain constructor.
     * @param SimpleErrorController $controller
     * @param array $interceptors
     */
    public function __construct(SimpleErrorController $controller, array $interceptors) {
        $this->controller = $controller;
        foreach($interceptors as $interceptor) {
            if(is_subclass_of($interceptor, Interceptor::class)) {
                $interceptor = new CompatibleWrapperInterceptor($interceptor);
            }
            $this->interceptors[] = $interceptor;
        }
    }

    /**
     * @return SimpleErrorController
     */
    public function getController(): SimpleErrorController {
        return $this->controller;
    }

    /**
     * @return array
     */
    public function getInterceptors(): array {
        return $this->interceptors;
    }

}
