<?php

namespace IZON\MVC\Messages;

use Dflydev\FigCookies\FigResponseCookies;
use Dflydev\FigCookies\SetCookie;
use Dflydev\FigCookies\SetCookies;
use IZON\MVC\ModelAndView;

/**
 * Trida obsluhujici request
 *
 * @author IZON s.r.o. <info@izon.cz>
 *
 * @version 1.0
 *
 * @package MVC
 */
class HttpResponse extends \GuzzleHttp\Psr7\Response implements HttpResponseInterface {
    /**
     * @var ModelAndView|null
     */
    protected $modelAndView;

    public function withModelAndView(?ModelAndView $modelAndView) : HttpResponseInterface {
        $clone = clone $this;
        $clone->modelAndView = $modelAndView;
        return $clone;
    }

    /**
     * @return ModelAndView|null
     */
    public function getModelAndView(): ?ModelAndView {
        return $this->modelAndView;
    }

    public function getSetCookies() : SetCookies {
        return SetCookies::fromResponse($this);
    }

    public function withCookie(SetCookie $cookie) : HttpResponseInterface {
        return FigResponseCookies::set($this, $cookie);
    }

    public function withoutCookie(string $cookieName) : HttpResponseInterface {
        return FigResponseCookies::remove($this, $cookieName);
    }

    public function expireCookie(string $cookieName): HttpResponseInterface {
        return FigResponseCookies::expire($this, $cookieName);
    }


}
