<?php


namespace IZON\MVC\Interceptors;


use IZON\MVC\Messages\HttpRequestInterface;
use IZON\MVC\Messages\HttpResponseInterface;
use IZON\MVC\ModelAndView;
use IZON\Templating\TemplateStreamInterface;

class TemplateDataInterceptor implements InterceptorInterface {

    protected $parameters = [];

    /**
     * TemplateDataInterceptor constructor.
     * @param array $parameters
     */
    public function __construct(array $parameters) {
        $this->parameters = $parameters;
    }


    public function preHandle(HttpRequestInterface $request): HttpRequestInterface {
        return $request;
    }

    public function postHandle(HttpRequestInterface $request, HttpResponseInterface $response): HttpResponseInterface {
        if(!$response->getBody() instanceof TemplateStreamInterface) {
            return $response;
        }
        $parameters = $this->parameters;
        $parameters['_locale'] = $request->getLocale();
        foreach($parameters as $name => $value) {
            $response->getBody()->putParameter($name, $value);
        }
        return $response;
    }

    public function afterCompletion(
        HttpRequestInterface $request,
        HttpResponseInterface $response,
        $exception
    ): HttpResponseInterface {
        // TODO: Implement afterCompletion() method.
        return $response;
    }

}
