<?php


namespace IZON\MVC;


use IZON\MVC\Messages\HttpRequestInterface;
use IZON\Utils\Locale;

/**
 * Class HttpRequest
 * @package IZON\MVC
 * @author Lukáš Linhart <linhart@izon.cz>
 * @deprecated
 */
interface HttpRequest extends HttpRequestInterface {

    public function hasParameter(string $paramName);

    public function getParameter(string $paramName);

    /**
     * @deprecated DO NOT USE
     */
    public function addParameter($parameterName, $parameter);

    /**
     * vraci pole vsech parametru z requestu, to same jako $_REQUEST
     * @deprecated
     */
    public function getParameters();


    public function withDomainUID(string $domainUID);

    public function withDomain(string $domain);

    public function getSession();

    function withSession(?\IZON\MVC\Session\HttpSession $session);

    /**
     * vraci parametr ze session
     */
    public function getSessionParameter($name);

    /**
     * ulozi parametr do session
     */
    public function setSessionParameter($name, $value);

    /**
     * @return Locale
     */
    function getLocale();

    /**
     * TODO: neni ciste potom odstranit
     * @param Locale $locale
     */
    function withLocale(?Locale $locale);

    function getCalledControllerId();

    function setCalledControllerId($calledControllerId);

    /**
     * Ulozi FlashMessage do session pod jejim id pro pouziti na webu
     *
     * @param string $content obsah zpravy
     * @param FlashMessage|string $id objekt FlashMessage nebo identifikator zpravy
     * @param string $level [OK|WARNING|ERROR]
     */
    public function setFlashMessageWeb($content, $id = NULL, $level = FlashMessage::LEVEL_OK);

    function getURL();

    /**
     * Ulozi FlashMessage do session pod jejim id pro pouziti na webu. Aktualne nahrazeno setFlashMessageWeb
     *
     * @param string $content obsah zpravy
     * @param FlashMessage|string $id objekt FlashMessage nebo identifikator zpravy
     * @param string $level [OK|WARNING|ERROR]
     * @deprecated
     */
    public function setFlashMessage($content, $id = NULL, $level = FlashMessage::LEVEL_OK);

    /**
     * Ulozi FlashMessage do session pod jejim id pro pouziti na webu
     *
     * @param FlashMessage|string $id objekt FlashMessage nebo identifikator zpravy
     * @param string $id identifier
     * @param string $level [OK|WARNING|ERROR]
     */
    public function setFlashMessageAdmin($content, $id = NULL, $level = FlashMessage::LEVEL_OK);

    /**
     * @return string
     */
    public function getDomain(): string;

    /**
     * @return string
     */
    public function getDomainUID(): string;

}
