<?php


namespace IZON\MVC\Controllers;


use Exception;
use IZON\MVC\Messages\HttpRequestInterface;
use IZON\MVC\Messages\HttpResponseInterface;
use IZON\Templating\TemplateStream;

class SimpleTemplateController {

    protected $template;

    public function __construct($template) {
        $this->template = $template;
    }

    public function execute(HttpRequestInterface $request, HttpResponseInterface $response) {
        if(empty($this->template)) {
            throw new Exception("template not set");
        }
        return $response->withBody(new TemplateStream($this->template));
    }
}
