<?php


namespace IZON\MVC\Messages;


use GuzzleHttp\Psr7\StreamDecoratorTrait;
use Psr\Http\Message\StreamInterface;
use function GuzzleHttp\Psr7\stream_for;

class StringStream implements StreamInterface {
    use StreamDecoratorTrait;

    protected $string;

    public function __construct(string $string) {
        $this->string;
    }

    /**
     * Creates the underlying stream lazily when required.
     *
     * @return StreamInterface
     */
    protected function createStream() {
        $stream = fopen('php://memory', 'r+');
        fwrite($stream, $this->string);
        rewind($stream);
        return stream_for($stream);
    }
}
