<?php

namespace IZON\MVC\Exceptions\Handlers;

use Exception;
use IZON\MVC\HttpRequest;
use IZON\MVC\Messages\HttpRequestInterface;
use IZON\MVC\Messages\HttpResponseInterface;
use IZON\MVC\ModelAndView;


/**
 * Interface IAppExceptionHandler
 *
 * Interface for various exception handlers
 * @package IZON\MVC\Exceptions\Handlers
 */
interface IAppExceptionHandler {

    /**
     *
     * @param \Throwable $exception
     * @return boolean true if exception can be handle by that handler
     */
    public function isFor(\Throwable $exception);

    /**
     * @return int log level to log this exception from LogLevel
     */
    public function getLogLevel();

    /**
     * Process exception
     *
     * Work and resolve that exception
     *
     * @param \Throwable $exception
     * @param HttpRequestInterface|null $request
     * @return HttpResponseInterface|null - no View to render, ModelAndView - view to rende
     */
    public function handleException(\Throwable $exception,  ?HttpRequestInterface $request, ?HttpResponseInterface $response) : ?HttpResponseInterface;
}
