<?php

namespace IZON\MVC\Exceptions\Handlers;

use Exception;
use IZON\MVC\HttpRequest;
use Throwable;

use \IZON\Logs\LogLevel;
use \IZON\MVC\Exceptions\InternalServerErrorException;

/**
 * Handles if page is not found
 */
class InternalServerErrorExceptionHandler implements IAppExceptionHandler {

    /**
     * @var string
     */
    protected $htmlToShow;

    /**
     * InternalServerErrorExceptionHandler constructor.
     * @param string $htmlToShow - string absolute path (form htdocs) to InternalServerError Page (file)
     */
    public function __construct(string $htmlToShow) {
        $this->htmlToShow = $htmlToShow;
    }

    /**
     * @return int
     */
    public function getLogLevel() {
        return LogLevel::ERROR;
    }

    /**
     * @param Throwable $exception
     * @return \IZON\MVC\ModelAndView|null
     */
    public function handleException(Throwable $exception, ?HttpRequest $request) {
        header($_SERVER['SERVER_PROTOCOL'].' 500 Internal Server Error');
        require $this->htmlToShow;
        return null;
    }

    /**
     * @param Exception $exception
     * @return bool
     */
    public function isFor(Throwable $exception) {
        return $exception instanceof Throwable;
    }
}
