<?php

namespace IZON\MVC\Routers;

use IZON\Utils\Locale;

use IZON\MVC\HttpRequest;
use IZON\MVC\Routers\RouteInfo;

/**
 * Definice dopredneho a zpetneho routovani
 */
interface RouteDefinition {
    
    /**
     * but vrací RouteInfo pokud mapuje dany pozadavek nebo NULL,
     * pokud se ma pouzit dalsi RouteDefinition v poradi
     * @param HttpRequest $request
     * @return RouteInfo|NULL definice routovani
     */
    public function findRoute(HttpRequest $request);
    
    /**
     * pro controller s id $controllerId najde adresu pres kterou je ho mozno volat
     * @param string $controllerId id controlleru
     * @param array $parameters parametry, ptere se maji predat do adresy
     * @param string $methodName nazev metody, ktera se ma na controlleru zavolat
     * @param Locale $locale pro jake locale se ma najit routovani
     * @return string|NULL url pres ktere se da volat nebo NULL pokud RouteDefinition nemapuje tento controller
     * @throws Exception
     */
    public function findURL($controllerId, array $parameters, $methodName, Locale $locale);
}
