<?php

namespace IZON\MVC\Routers\Factories;

use IZON\MVC\Locale\LocaleResolver;
use IZON\MVC\Routers\RouteDefinition;
use IZON\MVC\Routers\Router;

/**
 * Description of RouterFactory
 *
 * @author Lukáš Linhart <linhart@izon.cz>
 */
class RouterFactory implements IRouterFactory {
    /**
     *
     * @var RouteDefinition[]
     */
    protected $routerDefinitions;
    /**
     *
     * @var LocaleResolver
     */
    protected $localeResolver;
    /**
     *
     * @var bool
     */
    protected $redirectWithoutTailingSlash;
    protected $router;

    public function __construct(array $routerDefinitions, LocaleResolver $localeResolver, $redirectWithoutTailingSlash) {
        $this->routerDefinitions = $routerDefinitions;
        $this->localeResolver = $localeResolver;
        $this->redirectWithoutTailingSlash = $redirectWithoutTailingSlash;
    }

    public function getRouter() {
        if(empty($this->router)) {
            $router = new Router($this->routerDefinitions);
            /* @var $router Router */
            $router->setLocaleResolver($this->localeResolver);
            if(!empty($this->redirectWithoutTailingSlash)) {
                $router->setRedirectToURLWithoutTailingSlash($this->redirectWithoutTailingSlash);
            }
            $this->router = $router;
        }
        return $this->router;
    }

}
