<?php

namespace IZON\MVC\Exceptions\Handlers;

use Exception;
use \IZON\Logs\LogLevel;
use IZON\MVC\Controller;
use IZON\MVC\Controllers\SimpleErrorController;
use \IZON\MVC\Exceptions\PageNotFoundException;
use IZON\MVC\HttpRequest;
use IZON\MVC\Interceptors\Interceptor;
use IZON\MVC\Interceptors\PreHandleResult;
use Throwable;

/**
 * Handles if page is not found
 */
class PageNotFoundExceptionHandler implements IAppExceptionHandler {

    /**
     * @var SimpleErrorController
     */
    protected $controller;
    /**
     * @var Interceptor[]
     */
    protected $interceptors = [];

    /**
     * PageNotFoundExceptionHandler constructor.
     * @param SimpleErrorController $controller
     */
    public function __construct(SimpleErrorController $controller) {
        $this->controller = $controller;
    }

    /**
     * @param Interceptor[] $interceptors
     */
    public function setInterceptors(array $interceptors): void {
        $this->interceptors = $interceptors;
    }


    public function getLogLevel() {
        return LogLevel::WARN;
    }

    /***
     * @param PageNotFoundException $exception
     * @param HttpRequest $request
     * @throws Exception
     * @return \IZON\MVC\ModelAndView|NULL
     */
    public function handleException(Throwable $exception, ?HttpRequest $request) {
        if(empty($request)){
            throw new Exception(self::class . ' is not able to handle exception without HttpRequest object');
        }

        foreach ($this->interceptors as $interceptor) {
            $preHandleResult = $interceptor->preHandle($request);
            if ($preHandleResult instanceof PreHandleResult) {
                if($preHandleResult->isExternalRedirect() || $preHandleResult->isInternalRedirect()) {

                }
            }
        }

        $modelAndView = $this->controller->execute($request);

        foreach ($this->interceptors as $interceptor) {
            $interceptor->postHandle($request, $modelAndView);
        }

        foreach($this->interceptors as $interceptor) {
            $interceptor->afterCompletion($request, null);
        }

        return $modelAndView;
    }

    public function isFor(Throwable $exception) {
        return $exception instanceof PageNotFoundException;
    }
}
