<?php

namespace IZON\MVC\Views\StaticContent;

/**
 * iniformation how to minifi files
 */
class FilesMinificationInfo
{
    public const FILE_TYPE_JAVASCRIPT = 'js';

    public const FILE_TYPE_CSS = 'css';

    /**
     * @var string[] absolute path of souce files to be minifies
     */
    protected $sourceFiles = [];

    /**
     * @var string absolute path to target dir where to put minified file
     */
    protected $targetDir;

    /**
     * @var string file name to minify to
     */
    protected $targetFileName;

    /**
     * @var string file name to minify to
     */
    protected $fileType;


    ///
    public function __construct(array $sourceFiles, string $targetDir, string $targetFileName, $fileType)
    {
        $this->sourceFiles = $sourceFiles;
        $this->targetDir = $targetDir;
        $this->targetFileName = $targetFileName;
        $this->fileType = $fileType;
    }

    public function getSourceFiles(): array
    {
        return $this->sourceFiles;
    }

    public function getTargetDir()
    {
        return $this->targetDir;
    }

    public function getTargetFileName()
    {
        return $this->targetFileName;
    }

    public function getFileType()
    {
        return $this->fileType;
    }
}
