<?php

namespace IZON\MVC\Tasks;

use IZON\Tasks\Task;

/**
 * cleans expired files in tmp/user-data folder
 */
class ClearExpiredTemporaryUserDataTask implements Task
{
    /**
     * @var string user-data directory
     */
    protected $userDataTempDir;

    /**
     * @var int how long to consider file to be expired
     */
    protected $maxActiveTime = 60 * 60 * 24;


    public function __construct(string $userDataTempDir)
    {
        $this->userDataTempDir = $userDataTempDir;
    }


    public function run(array $argv)
    {
        $olderThan = time() - $this->maxActiveTime;

        if (file_exists($this->userDataTempDir)) {
            foreach (scandir($this->userDataTempDir) as $dir) {
                if ($dir != "."
                    && $dir != "..") {
                    $empty = $this->deleteOlderRecursivelly($this->userDataTempDir . "/" . $dir, $olderThan);
                    if ($empty) {
                        rmdir($this->userDataTempDir . "/" . $dir);
                    }
                }
            }
        }
    }

    /**
     * smaze obsah adresare ktery je starsi nez $olderThan a vsechny prazdne adresare
     * @param string $dir
     * @param integer $olderThan timestamp
     */
    public function deleteOlderRecursivelly($dir, $olderThan)
    {
        $isEmptyDir = true;
        foreach (scandir($dir) as $subFile) {
            $absFileDir = $dir . "/" . $subFile;

            if (is_dir($absFileDir)) {
                if ($subFile != "."
                    && $subFile != "..") {
                    $empty = $this->deleteOlderRecursivelly($absFileDir, $olderThan);
                    if ($empty) { // smazat prazdny adresar
                        rmdir($absFileDir);
                    }
                    $isEmptyDir = $isEmptyDir && $empty;
                }
            } else { // je soubor smazat ho
                $modTile = filemtime($absFileDir);
                if ($modTile < $olderThan) {
                    unlink($absFileDir);
                } else {
                    $isEmptyDir = false;
                }
            }
        }
        return $isEmptyDir;
    }

    public function setMaxActiveTime($maxActiveTime)
    {
        $this->maxActiveTime = $maxActiveTime;
    }
}
