<?php

namespace IZON\MVC\SessionHandlers;

use SessionHandler;
use SessionHandlerInterface;

/**
 * slouzi k ulkidu v tmp/user-data
 * smaze vsechny soubory starsi nez session expire time a vsechny prazdne adresare
 */
class ClearTemporaryUserDataSessionHandler extends SessionHandler implements SessionHandlerInterface
{
    protected string $userDataTempDir;

    /**
     * jak dlouho musi byt soubor na fs nez se smaze
     * @var int
     */
    protected int $maxActiveTime = 60 * 60 * 24;

    /**
     *
     */
    public function __construct($userDataTempDir)
    {
        $this->userDataTempDir = $userDataTempDir;
    }
    //
    //    public function read($session_id) {
    //        parent::read($session_id);
    //    }

    /**
     * maze session kdyz je pozadavek za zniceni session
     * @param string $id
     * @return bool
     */
    public function destroy($id)
    {
        $ret = parent::destroy($id);

        // smazat adresar a soubory z uzivatelskeho temporary adresare
        $userTempDir = $this->userDataTempDir . "/" . $id;
        if (file_exists($userTempDir)) {
            $this->deleteRecursivelly($userTempDir);
            rmdir($userTempDir);
        }

        return $ret;
    }

    /**
     * smaze obsah adresare kompletne rekurzivne
     * @param string $dir
     */
    public function deleteRecursivelly($dir)
    {
        foreach (scandir($dir) as $subFile) {
            $absFileDir = $dir . "/" . $subFile;

            if (is_dir($absFileDir)) {
                if ($subFile != "."
                    && $subFile != "..") {
                    $this->deleteRecursivelly($absFileDir);
                    rmdir($absFileDir);
                }
            } else { // je soubor smazat ho
                unlink($absFileDir);
            }
        }
    }

    public function gc($max_lifetime)
    {
        $ret = parent::gc($max_lifetime);
        // vymaze vsechny prazdne uzivatelske adresare nebo ty co obsahuji soubory starsi nez $this->maxActiveTime
        $olderThan = time() - $this->maxActiveTime;

        if (file_exists($this->userDataTempDir)) {
            foreach (scandir($this->userDataTempDir) as $dir) {
                if ($dir != "."
                    && $dir != "..") {
                    $empty = $this->deleteOlderRecursivelly($this->userDataTempDir . "/" . $dir, $olderThan);
                    if ($empty) {
                        rmdir($this->userDataTempDir . "/" . $dir);
                    }
                }
            }
        }

        return $ret;
    }

    /**
     * smaze obsah adresare ktery je starsi nez $olderThan a vsechny prazdne adresare
     * @param string $dir
     * @param integer $olderThan timestamp
     */
    public function deleteOlderRecursivelly($dir, $olderThan)
    {
        $isEmptyDir = true;
        foreach (scandir($dir) as $subFile) {
            $absFileDir = $dir . "/" . $subFile;

            if (is_dir($absFileDir)) {
                if ($subFile != "."
                    && $subFile != "..") {
                    $empty = $this->deleteOlderRecursivelly($absFileDir, $olderThan);
                    if ($empty) { // smazat prazdny adresar
                        rmdir($absFileDir);
                    }
                    $isEmptyDir = $isEmptyDir && $empty;
                }
            } else { // je soubor smazat ho
                $modTile = filemtime($absFileDir);
                if ($modTile < $olderThan) {
                    unlink($absFileDir);
                } else {
                    $isEmptyDir = false;
                }
            }
        }
        return $isEmptyDir;
    }
}
