<?php

namespace IZON\MVC\Routers;

use IZON\MVC\Context\Context;
use IZON\MVC\Interceptors\Interceptor;

/**
 * informace kam se ma adresa routovat
 */
class RouteInfo
{
    /**
     * @var integer jaky se ma provest redirect: null je zadny, jinak 301 nebo 302, pokud je redirect tak pouzij url jako adresu kam presmerovat
     */
    protected $redirectCode = null;

    /**
     * url, ktere bylo pouzito
     * @var string
     */
    protected $url;

    /**
     * id controlleru, ktery se ma volat
     * @var string
     */
    protected $contrlollerId;

    /**
     * naze metody, ktera se ma volat
     * @var string
     */
    protected $methodName;

    /**
     * pattern, ktery odpovida dane adrese
     * @var string
     */
    protected $pattern;

    /**
     * parametry, ktere byly z adresy extrahovany
     * @var mixed[]
     */
    protected $parameters = [];

    /**
     * jake interceptory se maji pri vykonavani zavolat,
     * contains interceptor object or indetifier to search in DI container
     * @var string[]|Interceptor[]
     */
    protected $interceptors = [];

    /**
     * @var Context
     */
    protected $context;


    public function getURL()
    {
        return $this->url;
    }

    public function setURL($url)
    {
        $this->url = $url;
    }

    /// geberated getters and setters


    public function getContrlollerId()
    {
        return $this->contrlollerId;
    }

    public function setContrlollerId($contrlollerId)
    {
        $this->contrlollerId = $contrlollerId;
    }

    public function getMethodName()
    {
        return $this->methodName;
    }

    public function setMethodName($methodName)
    {
        $this->methodName = $methodName;
    }

    public function getPattern()
    {
        return $this->pattern;
    }

    public function setPattern($pattern)
    {
        $this->pattern = $pattern;
    }

    public function getParameters()
    {
        return $this->parameters;
    }

    public function setParameters($parameters)
    {
        $this->parameters = $parameters;
    }

    public function getInterceptors()
    {
        return $this->interceptors;
    }

    public function setInterceptors(array $interceptors)
    {
        $this->interceptors = $interceptors;
    }

    public function addInterceptor($interceptor)
    {
        $this->interceptors[] = $interceptor;
    }

    public function addInterceptors($interceptors)
    {
        $this->interceptors = array_merge($this->interceptors, $interceptors);
    }

    public function getRedirectCode()
    {
        return $this->redirectCode;
    }

    public function setRedirectCode($redirectCode)
    {
        $this->redirectCode = $redirectCode;
    }

    public function getContext()
    {
        return $this->context;
    }

    public function setContext(Context $context)
    {
        $this->context = $context;
    }

    public function __toString()
    {
        return print_r((array)$this, true);
    }
}
