<?php

namespace IZON\MVC;

/**
 * Obsauje informace o strance jako kratky titulek, titulek, popis atd.
 */
class PageInfo
{
    public const PAGE_INFO_INDENTIFIER = '_pageInfo';

    /**
     * url prave zobrazovane stranky
     * @var string
     */
    protected $url;


    /**
     * which controller serves this page
     * @var string
     */
    protected $controllerId;


    /**
     * titulek stranky, ktery se ma pouzit v title tgagu v hlavicce
     * @var string
     */
    protected $title;

    /**
     * kratky nazev, ktery se ma pouzit treba ve drobeccich
     * @var string
     */
    protected $shortTitle;

    /**
     * kratky popis stranky, ktery se dapouzit v description tagu
     * @var string
     */
    protected $description;

    /**
     * obsahuje klicova slova pouzivana v keywords tagu v hlavicce
     * @var string
     */
    protected $keywords;

    /**
     * obsah hlavickoveho tagu robots
     * @var string
     */
    protected $robots;

    /**
     * @var array pole pripadnych parametru pro volani teto stranky pokud je zname pri resolvovani url na controller
     */
    protected $parameters = [];

    /**
     * @var string|null name of controller method, that was called
     */
    protected $methodName = null;


    /**
     * drobecky ke koreni webu
     * TODO: co v nem ma presne byt
     * Obsahuje pageinfo od predku
     * @var array
     */
    protected $breadcrumbs = [];


    /**
     *
     * @param string $controllerId
     * @return boolean returns true has parent a.i. first predecessot on part to root page
     */
    public function hasParent($controllerId)
    {
        if (isset($this->breadcrumbs[count($this->breadcrumbs) - 1])) { // ma alespon jednoho predka
            $pageInfo = $this->breadcrumbs[count($this->breadcrumbs) - 1];
            if ($pageInfo->getControllerId() == $controllerId) {
                return true;
            }
        }
        return false;
    }

    public function getControllerId()
    {
        return $this->controllerId;
    }

    public function setControllerId($controllerId)
    {
        $this->controllerId = $controllerId;
    }

    /**
     *
     * @param string $controllerId
     * @return boolean returns true if has predecessor
     */
    public function hasPredecessor($controllerId)
    {
        foreach ($this->breadcrumbs as $pageInfo) {
            if ($pageInfo->getControllerId() == $controllerId) {
                return true;
            }
        }
        return false;
    }


    /// geneovane gettery a settery

    /**
     * @deprecated
     */
    public function getDesctiprion()
    {
        return $this->getDescription();
    }

    public function getDescription()
    {
        return $this->description;
    }

    public function setDescription($description)
    {
        $this->description = $description;
    }

    /**
     * @deprecated
     */
    public function setDesctiprion($description)
    {
        $this->setDescription($description);
    }

    public function getURL()
    {
        return $this->url;
    }

    public function setURL($url)
    {
        $this->url = $url;
    }

    public function getTitle()
    {
        return $this->title;
    }

    public function setTitle($title)
    {
        $this->title = $title;
    }

    public function getShortTitle()
    {
        return $this->shortTitle;
    }

    public function setShortTitle($shortTitle)
    {
        $this->shortTitle = $shortTitle;
    }

    public function getKeywords()
    {
        return $this->keywords;
    }

    public function setKeywords($keywords)
    {
        $this->keywords = $keywords;
    }

    public function getRobots()
    {
        return $this->robots;
    }

    public function setRobots($robots)
    {
        $this->robots = $robots;
    }

    public function getParameters()
    {
        return $this->parameters;
    }

    public function setParameters($parameters)
    {
        $this->parameters = $parameters;
    }

    public function getBreadcrumbs()
    {
        return $this->breadcrumbs;
    }

    public function setBreadcrumbs($breadcrumbs)
    {
        $this->breadcrumbs = $breadcrumbs;
    }

    public function getMethodName()
    {
        return $this->methodName;
    }

    public function setMethodName($methodName)
    {
        $this->methodName = $methodName;
    }
}
