<?php

namespace IZON\MVC\Json;

use Exception;
use JsonSerializable;

/**
 * jsonova odpoved
 */
class JsonResponse implements JsonSerializable
{
    public const RESULT_OK = "ok";

    public const RESULT_ERROR = "error";

    /**
     * @var string typ odpovedi, na jejim zaklade se potm zpracovavaji nastavena data
     */
    public $result;

    /**
     * @var mixed
     */
    public $data;

    /**
     * @var string error message
     */
    public $error;

    protected ?array $customData = null;

    /**
     * vytvari odpoved kdy vse probehlo bez problemu
     * @param mixed $data data prevadena do jsonu ulozena pod klicem data
     */
    public static function createResponse($data)
    {
        $response = new JsonResponse();
        $response->result = self::RESULT_OK;
        $response->data = $data;

        return $response;
    }

    /**
     * doslo k obecne chybe, chybova hlaska je ulozena pod klicem
     * @param string $errorMessage text chyby error
     */
    public static function createErrorResponse($errorMessage)
    {
        $response = new JsonResponse();
        $response->result = self::RESULT_ERROR;
        $response->error = $errorMessage;

        return $response;
    }

    /**
     * obecna jsonov odpoved kde je mozne si poslat jakekolidata
     * @param string $result typ odpovedi
     * @param array $data data predavana odpovedi, jdotlive klice se navazou do obektu
     * @throws Exception
     */
    public static function createCustomResponse($result, array $data)
    {
        $response = new JsonResponse();
        $response->result = $result;
        foreach ($data as $key => $value) {
            if ($key == "result") {
                throw new Exception("Data nesmi obsahovat klic result, ktery se rezervovan pro predani typu odpovedi");
            }
        }
        $response->customData = $data;

        return $response;
    }

    /**
     * @return mixed
     */
    public function jsonSerialize()
    {
        $response = [
            'result' => $this->result,
        ];
        if ($this->result == $this::RESULT_OK) {
            $response['data'] = $this->data;
        } elseif ($this->result == $this::RESULT_ERROR) {
            $response['error'] = $this->error;
        }
        if (is_array($this->customData) && count($this->customData) > 0) {
            $response = array_merge($response, $this->customData);
        }
        
        return $response;
    }
}
