<?php

namespace IZON\MVC\Interceptors;

use IZON\Utils\Locale;

/**
 * Result of prehandle function in Intereceptor
 */
class PreHandleResult
{
    /**
     * address tu redirect out of web
     * contains protpcol
     * @var string|null
     */
    protected $redirectAddress = null;

    /**
     * specifies controller to redirect to
     * @var string|null
     */
    protected $controllerId = null;

    /**
     * parameters used to generate redirect adderss
     * @var mixed[]
     */
    protected $parameters = [];

    /**
     * @var string|null jaka metoda se ma volat
     */
    protected $methodName = null;

    /**
     * @var Locale|null jake locale se ma zobrazit
     */
    protected $locale = null;

    /**
     * creates redirect to some internal controller
     * @param string $controllerId
     * @param array<string, mixed> $parameters
     * @param null|string $methodName
     * @param null|Locale $locale
     * @return PreHandleResult
     */
    public static function getInternalRedirect(
        string $controllerId,
        array $parameters = [],
        ?string $methodName = null,
        ?Locale $locale = null
    ) {
        $preHandleResult = new PreHandleResult();

        $preHandleResult->controllerId = $controllerId;
        $preHandleResult->parameters = $parameters;
        $preHandleResult->methodName = $methodName;
        $preHandleResult->locale = $locale;

        return $preHandleResult;
    }

    /**
     * creates redirect to possibly external address or static site
     * @param string $redirectAddress
     * @return PreHandleResult
     */
    public static function getExternalRedirect($redirectAddress)
    {
        $preHandleResult = new PreHandleResult();

        $preHandleResult->redirectAddress = $redirectAddress;

        return $preHandleResult;
    }

    /**
     *
     * @return boolean if redirect is requested
     */
    public function isInternalRedirect()
    {
        return $this->controllerId != null;
    }

    /**
     *
     * @return boolean if redirect is requested
     */
    public function isExternalRedirect()
    {
        return $this->redirectAddress != null;
    }

    public function getRedirectAddress()
    {
        return $this->redirectAddress;
    }

    public function getControllerId()
    {
        return $this->controllerId;
    }

    public function getParameters()
    {
        return $this->parameters;
    }

    public function getMethodName()
    {
        return $this->methodName;
    }

    public function getLocale()
    {
        return $this->locale;
    }
}
