<?php

namespace IZON\MVC\Interceptors;

use IZON\MVC\HttpRequest;
use IZON\MVC\ModelAndView;
use IZON\MVC\PageInfo;

/**
 * zkontroluje jestli je v HttpRequest PageInfo a jestli e tak ho presune do
 * ModelAndView
 */
class PageInfoInterceptor implements Interceptor
{
    public function __construct()
    {
    }

    public function afterCompletion(HttpRequest $request, $exception)
    {
    }

    public function postHandle(HttpRequest $request, ModelAndView $model)
    {
        if ($request->hasParameter(PageInfo::PAGE_INFO_INDENTIFIER)) { // pokud ma PageInfo tak ho vrati
            $model->putParameter(
                PageInfo::PAGE_INFO_INDENTIFIER,
                $request->getParameter(PageInfo::PAGE_INFO_INDENTIFIER)
            );
        }

        return $model;
    }

    public function preHandle(HttpRequest $request)
    {
        return null;
    }
}
