<?php

namespace IZON\MVC\Interceptors;

use IZON\MVC\HttpRequest;
use IZON\MVC\ModelAndView;

/**
 * zkontroluje jestli je v HttpRequest PageInfo a jestli e tak ho presune do
 * ModelAndView
 */
class LoadConfigVariableInterceptor implements Interceptor
{
    protected $modelAndViewKey = null;

    protected $value = null;

    public function __construct($modelAndViewKey, $value)
    {
        $this->modelAndViewKey = $modelAndViewKey;
        $this->value = $value;
    }

    public function afterCompletion(HttpRequest $request, $exception)
    {
    }

    public function postHandle(HttpRequest $request, ModelAndView $model)
    {
        $model->putParameter(
            $this->modelAndViewKey,
            $this->value
        );
    }

    public function preHandle(HttpRequest $request)
    {
        return null;
    }
}
