<?php

namespace IZON\MVC;

use IZON\Utils\Locale;

/**
 * Trida obsluhujici request
 *
 * @author IZON s.r.o. <info@izon.cz>
 * @copyright Copyright 2009, HI Software s.r.o.
 *
 * @version 1.0
 *
 * @package MVC
 */
class HttpRequest
{
    /**
     * @var string indentifikator volaneho controlleru, mel by nastavit router
     */
    protected $calledControllerId;

    /**
     * jake url bylo volano
     * @var string
     */
    private $url;

    /**
     * parametry predane v url nebo postu
     * @var array
     */
    private $parameters;

    /**
     * @var null|array|object
     */
    private $parsedBody;

    /**
     * jaky jazyk byl zvolen pomoci url
     * @var Locale
     */
    private $locale;

    /**
     * @var HttpSession
     */
    private $session;

    public function __construct($url, $parameters, $locale)
    {
        //        var_dump($parameters);
        $this->url = $url;
        $this->parameters = $parameters;
        $this->locale = $locale;

        $this->session = new HttpSession();
    }


    public function hasParameter($paramName)
    {
        return isset($this->parameters[$paramName]);
        // TODO: NEWVERSION pouzit spise tohle
        //        return array_key_exists($paramName, $this->parameters);
    }

    public function getSession()
    {
        return $this->session;
    }

    public function getMethod()
    {
        return $_SERVER['REQUEST_METHOD'];
    }

    /**
     * vraci pole vsech parametru z requestu, to same jako $_REQUEST
     */
    public function getParameters()
    {
        return $this->parameters;
    }

    /**
     * TODO: neni ciste pozdeji odstranit
     * @param string $parameterName
     * @param mixed $parameter
     */
    public function addParameter($parameterName, $parameter)
    {
        $this->parameters[$parameterName] = $parameter;
    }

    /**
     * locale for this request
     * @return Locale
     */
    public function getLocale()
    {
        return $this->locale;
    }

    /**
     * TODO: neni ciste potom odstranit
     * @param Locale $locale
     */
    public function setLocale(Locale $locale)
    {
        $this->locale = $locale;
    }

    public function getURL()
    {
        return $this->url;
    }

    public function getCalledControllerId()
    {
        return $this->calledControllerId;
    }

    public function setCalledControllerId($calledControllerId)
    {
        $this->calledControllerId = $calledControllerId;
    }

    /**
     * Ulozi FlashMessage do session pod jejim id pro pouziti na webu
     *
     * @param string $content obsah zpravy
     * @param FlashMessage|string $id objekt FlashMessage nebo identifikator zpravy
     * @param string $level [OK|WARNING|ERROR]
     */
    public function setFlashMessageWeb($content, $id = null, $level = FlashMessage::LEVEL_OK)
    {
        $this->_setFlashMessage('web', $content, $id, $level);
    }

    /**
     * Save flash messaage into SESSION
     *
     * @param string $context [web|admin]
     * @param FlashMessage|string $content objekt FlashMessage nebo textovy obsah zpravy
     * @param string $id identifikator zpravy
     * @param string $level [OK|WARNING|ERROR]
     */
    protected function _setFlashMessage($context, $content, $id = null, $level = FlashMessage::LEVEL_OK)
    {
        $message = $content;
        if (!($content instanceof FlashMessage)) { // zprava se nepredava jako objekt
            $message = new FlashMessage($id, $content, $level);
        }
        $this->session->lock();
        $messages = $this->getSessionParameter('flashMessages');
        $messages[$context][$message->getId()] = $message;
        $this->setSessionParameter('flashMessages', $messages);
        $this->session->unlock();
    }

    /**
     * vraci parametr ze session
     */
    public function getSessionParameter($name)
    {
        $this->session->lock();
        $value = $this->session->getParameter($name);
        $this->session->unlock();
        return $value;
    }

    /**
     * vraci parametr z requestu
     */
    public function getParameter($paramName)
    {
        if (isset($this->parameters[$paramName])) {
            return $this->parameters[$paramName];
        } else {
            return null;
        }
    }

    /**
     * ulozi parametr do session
     */
    public function setSessionParameter($name, $value)
    {
        $this->session->lock();
        $this->session->setParameter($name, $value);
        $this->session->unlock();
    }

    /**
     * Ulozi FlashMessage do session pod jejim id pro pouziti na webu. Aktualne nahrazeno setFlashMessageWeb
     *
     * @param string $content obsah zpravy
     * @param FlashMessage|string $id objekt FlashMessage nebo identifikator zpravy
     * @param string $level [OK|WARNING|ERROR]
     * @deprecated
     */
    public function setFlashMessage($content, $id = null, $level = FlashMessage::LEVEL_OK)
    {
        $this->_setFlashMessage('web', $content, $id, $level);
    }

    /**
     * Ulozi FlashMessage do session pod jejim id pro pouziti na webu
     *
     * @param FlashMessage|string $id objekt FlashMessage nebo identifikator zpravy
     * @param string $id identifier
     * @param string $level [OK|WARNING|ERROR]
     */
    public function setFlashMessageAdmin($content, $id = null, $level = FlashMessage::LEVEL_OK)
    {
        $this->_setFlashMessage('admin', $content, $id, $level);
    }

    /**
     * currently supported body content types:
     * application/json
     * application/x-www-form-urlencoded
     * multipart/form-data
     * all parsed to array
     * @return array|object|null
     */
    public function getParsedBody()
    {
        return $this->parsedBody;
    }

    /**
     * @param array|object|null $parsedBody
     */
    public function setParsedBody($parsedBody)
    {
        $this->parsedBody = $parsedBody;
    }
}
