<?php

namespace IZON\MVC;

/**
 *
 * @author Vitezslav Jahn
 */
class FlashMessage
{
    /**
     * Vsecno v poradku
     */
    public const LEVEL_OK = 'OK';

    /**
     * Nekriticka chyba
     */
    public const LEVEL_WARNING = 'WARNING';

    /**
     * Kriticka chyba
     */
    public const LEVEL_ERROR = 'ERROR';

    /**
     * identifikator zpravy
     *
     * @var string
     */
    protected $id;

    /**
     * obsah zpravy - text, html, cokoliv
     *
     * @var mixed [string|object]
     */
    protected $content;

    /**
     *
     * @var string [ok|warning|error]
     */
    protected $level;

    /*
     * Stylove tridy
     *
     * @var array
     */
    protected $cssClass = [];

    /**
     *
     * @param string $id identifikator zpravy
     * @param string $content obsah zpravy
     * @param string $level [OK|WARNING|ERROR]
     */
    public function __construct($id, $content = '', $level = FlashMessage::LEVEL_OK)
    {
        $this->id = $id;
        $this->content = $content;
        $this->level = $level;
    }

    public function getId()
    {
        return $this->id;
    }

    public function setId($id)
    {
        $this->id = $id;
    }

    public function getContent()
    {
        return $this->content;
    }

    public function setContent($content)
    {
        $this->content = $content;
    }

    public function getLevel()
    {
        return $this->level;
    }

    public function setLevel($level)
    {
        $this->level = $level;
    }

    /**
     * Je level zpravy "OK", tzn. jen neco informativniho
     *
     * @return bool
     */
    public function isOk()
    {
        return $this->level == self::LEVEL_OK;
    }

    /**
     * Je level zpravy "WARNING", tzn. vyskytla se nejaka chyba, ale nejedna se o kririckou chybu
     *
     * @return bool
     */
    public function isWarning()
    {
        return $this->level == self::LEVEL_WARNING;
    }

    /**
     * Je level zpravy "ERROR", tzn. vyskytla se kriticka chyba
     *
     * @return bool
     */
    public function isError()
    {
        return $this->level == self::LEVEL_ERROR;
    }

    public function getCssClass()
    {
        return implode(' ', $this->cssClass);
    }

    public function setCssClass($cssClass)
    {
        $this->cssClass = $cssClass;
    }

    public function addCssClass($class)
    {
        $this->cssClass[] = $class;
    }
}
