<?php

namespace IZON\MVC\Exceptions\Handlers;

use Exception;
use IZON\MVC\HttpRequest;
use IZON\MVC\ModelAndView;
use Psr\Log\LogLevel;
use Throwable;

/**
 * Handles if page is not found
 */
class InternalServerErrorExceptionHandler implements AppExceptionHandlerInterface
{
    protected string $htmlToShow;

    /**
     * InternalServerErrorExceptionHandler constructor.
     * @param string $htmlToShow - string absolute path (form htdocs) to InternalServerError Page (file)
     */
    public function __construct(string $htmlToShow)
    {
        $this->htmlToShow = $htmlToShow;
    }

    public function getLogLevel(): string
    {
        return LogLevel::ERROR;
    }

    public function handleException(Throwable $exception, ?HttpRequest $request): ?ModelAndView
    {
        header($_SERVER['SERVER_PROTOCOL'] . ' 500 Internal Server Error');
        require $this->htmlToShow;
        return null;
    }

    /**
     * @param Exception $exception
     * @return bool
     */
    public function isFor(Throwable $exception): bool
    {
        // handle all exceptions
        return true;
    }
}
