<?php

namespace IZON\MVC\Exceptions\Handlers;

use IZON\MVC\HttpRequest;
use IZON\MVC\ModelAndView;
use Throwable;

/**
 * Interface for various exception handlers
 * @package IZON\MVC\Exceptions\Handlers
 * @deprecated use AppExceptionHandlerInterface instead
 */
interface IAppExceptionHandler
{
    /**
     *
     * @param Throwable $exception
     * @return bool true if exception can be handled by that handler
     */
    public function isFor(Throwable $exception);

    /**
     * @return string log level to log this exception from LogLevel
     */
    public function getLogLevel();

    /**
     * Process exception
     *
     * Work and resolve that exception
     *
     * @param Throwable $exception
     * @param HttpRequest|null $request
     * @return null|ModelAndView null - no View to render, ModelAndView - view to rende
     */
    public function handleException(Throwable $exception, ?HttpRequest $request);
}
