<?php

namespace IZON\MVC\Exceptions\Handlers;

use IZON\MVC\HttpRequest;
use IZON\MVC\ModelAndView;
use Throwable;

/**
 * Interface IAppExceptionHandler
 *
 * Interface for various exception handlers
 * @package IZON\MVC\Exceptions\Handlers
 */
interface AppExceptionHandlerInterface
{
    /**
     *
     * @param Throwable $exception
     * @return boolean true if exception can be handled by that handler
     */
    public function isFor(Throwable $exception): bool;

    /**
     * @return string log level to log this exception from LogLevel
     */
    public function getLogLevel(): string;

    /**
     * Process exception
     *
     * Work and resolve that exception
     *
     * @param Throwable $exception
     * @param HttpRequest|null $request
     * @return NULL|ModelAndView null - no View to render, ModelAndView - view to rende
     */
    public function handleException(Throwable $exception, ?HttpRequest $request): ?ModelAndView;
}
