<?php

namespace IZON\MVC\Exceptions\Handlers;

use Exception;
use IZON\MVC\Controllers\SimpleErrorController;
use IZON\MVC\Exceptions\AccessForbiddenException;
use IZON\MVC\HttpRequest;
use IZON\MVC\Interceptors\Interceptor;
use IZON\MVC\Interceptors\PreHandleResult;
use IZON\MVC\ModelAndView;
use Psr\Log\LogLevel;
use Throwable;

/**
 * Handles not accessable page request
 */
class AccessForbiddenExceptionHandler implements AppExceptionHandlerInterface
{
    /**
     * @var SimpleErrorController
     */
    protected $controller;

    /**
     * @var Interceptor[]
     */
    protected $interceptors = [];

    /**
     * AccessForbiddenExceptionHandler constructor.
     * @param SimpleErrorController $controller
     */
    public function __construct(SimpleErrorController $controller)
    {
        $this->controller = $controller;
    }

    /**
     * @param Interceptor[] $interceptors
     */
    public function setInterceptors(array $interceptors): void
    {
        $this->interceptors = $interceptors;
    }


    public function getLogLevel(): string
    {
        return LogLevel::WARNING;
    }

    /***
     * @param AccessForbiddenException $exception
     * @param HttpRequest $request
     * @return ModelAndView|NULL
     * @throws Exception
     */
    public function handleException(Throwable $exception, ?HttpRequest $request): ?ModelAndView
    {
        if (empty($request)) {
            throw new Exception(self::class . ' is not able to handle exception without HttpRequest object');
        }
        foreach ($this->interceptors as $interceptor) {
            $preHandleResult = $interceptor->preHandle($request);
            if ($preHandleResult instanceof PreHandleResult) {
                if ($preHandleResult->isExternalRedirect() || $preHandleResult->isInternalRedirect()) {
                }
            }
        }

        $modelAndView = $this->controller->execute($request);

        foreach ($this->interceptors as $interceptor) {
            $interceptor->postHandle($request, $modelAndView);
        }

        foreach ($this->interceptors as $interceptor) {
            $interceptor->afterCompletion($request, null);
        }

        return $modelAndView;
    }

    public function isFor(Throwable $exception): bool
    {
        return $exception instanceof AccessForbiddenException;
    }
}
