<?php

/**
 * Dependency Injection functions used for aplication config
 */

namespace IZON\DI\MVC;

use IZON\DI\DI;
use IZON\MVC\Config;

if (!function_exists('IZON\DI\MVC\appDir')) {
    /**
     * directory aplication is stored in
     */
    function appDir()
    {
        return DI::get(Config::APP_DIR_IDENTIFIER);
    }
}

if (!function_exists('IZON\DI\MVC\appSubDir')) {
    /**
     * Vraci adresar relativne k adresari aplikace
     */
    function appSubDir($relativeDir)
    {
        return DI::string("{" . Config::APP_DIR_IDENTIFIER . "}" . $relativeDir);
    }
}

if (!function_exists('IZON\DI\MVC\tmpSubDir')) {
    /**
     * Vraci adresar relativne k tmp adresari
     */
    function tmpSubDir($relativeDir)
    {
        return DI::string("{" . Config::TMP_DIR_IDENTIFIER . "}" . $relativeDir);
    }
}

if (!function_exists('IZON\DI\MVC\cacheSubDir')) {
    /**
     * Vraci adresar relativne k adresari cache
     */
    function cacheSubDir($relativeDir)
    {
        return DI::string("{" . Config::CACHE_DIR_IDENTIFIER . "}" . $relativeDir);
    }
}
