<?php

namespace IZON\MVC\Controllers;

use Exception;
use IZON\MVC\Controller;
use IZON\MVC\HttpRequest;
use IZON\MVC\ModelAndView;

/**
 * controller that calls view with name $viewName and sets http_response_code passed in controller
 * usefull for 500 page
 */
class SimpleErrorController implements Controller
{
    /**
     * @var string
     */
    protected $viewName;

    /**
     * @var integer
     */
    protected $httpResponseCode = 500;


    public function __construct($viewName, $httpResponseCode)
    {
        $this->viewName = $viewName;
        $this->httpResponseCode = $httpResponseCode;
    }

    public function execute(HttpRequest $request)
    {
        if ($this->viewName == null) {
            throw new Exception("viewName not set");
        }

        http_response_code($this->httpResponseCode);

        $modelAndView = new ModelAndView($this->viewName);
        return $modelAndView;
    }

    public function setHttpResponseCode($httpResponseCode)
    {
        $this->httpResponseCode = $httpResponseCode;
    }
}
