<?php

namespace IZON\MVC\Controllers;

use IZON\Forms\Form;
use IZON\Forms\FormDefinition;
use IZON\MVC\Controller;
use IZON\MVC\HttpRequest;
use IZON\MVC\ModelAndView;

/**
 * @deprecated use FormSet instead
 * controller that calls view with name $viewName
 */
abstract class FormController implements Controller
{
    public $hasFormError = false;
    protected $viewName = null;
    protected $viewFormName = null;
    protected $viewSuccessName = null;
    /**
     *
     * @var FormDefinition
     */
    protected $formDefinitions;
    /**
     *
     * @var HttpRequest
     */
    protected $request;
    protected $redirectOnSuccess = false;

    public function __construct()
    {
        $this->formDefinitions = new FormDefinition(); // @phpstan-ignore class.notFound
    }

    /**
     * Default crossroads for from actions ie:<br>
     * for load form trigger loadData method<br>
     * for submitted form
     * - succes: trigger loadData, setDataFromPost and onSubmit methods
     * - error: trigger loadData and setDataFromPost methods
     *
     * @param HttpRequest $request
     * @return ModelAndView
     */
    final public function execute(HttpRequest $request)
    {
        $this->request = $request;
        //echo '<pre>'.print_r($_POST, true).'</pre><br>';
        $this->loadFormDefinitions();

        if ($this->isFormSubmit()) {
            $this->executePreSubmit($request);
            $this->setDataFromPost($request);
            $this->customValidate($request);
            if ($this->validateForms($request)) {
                // validace probehla v poradku
                $mav = new ModelAndView($this->viewSuccessName);
                $mav = $this->loadData($request, $mav);
                $this->setDataFromPost($request);
                $mav = $this->onSubmit($request, $mav);
            } else {
                $this->hasFormError = true;
                // byla zaznamenana chyba formulare
                $mav = new ModelAndView($this->viewFormName);
                $mav = $this->loadData($request, $mav);
                $this->setDataFromPost($request);
            }
        } else {
            $mav = new ModelAndView($this->viewFormName);
            $mav = $this->loadData($request, $mav);
        }
        $mav = $this->setFormsToView($mav);
        return $mav;
    }

    /**
     * Definice formularu
     */
    abstract protected function loadFormDefinitions();

    /**
     * rozpoznava jestli se jednalo o odeslani formulare
     * odeslani formulare je to pouze pokud je v _REQUEST nasatavena hodnota action na post
     * da se prepsat v podtridach
     */
    protected function isFormSubmit()
    {
        return $this->request->getParameter("formAction") == "post";
    }

    /**
     * Spusti se jeste pred zapocetim validace - vyuzije se, <br>
     * pokud je treba data z formulare nejak upravit jeste pred tim, nez se zacne s validaci
     *
     * @param HttpRequest $request
     */
    protected function executePreSubmit(HttpRequest $request)
    {
    }

    /**
     * Sets data from HttpRequest to form defined in $ths->formDefinitions
     *
     * @param HttpRequest $request
     */
    protected function setDataFromPost(HttpRequest $request)
    {
        $forms = $this->formDefinitions->getForms();
        if (!empty($forms) && is_array($forms)) {
            /** @var Form $form */
            foreach ($forms as $key => $_form) {
                if (is_array($_form['form'])) {
                    foreach ($_form['form'] as $key => $value) {
                        $_form['form'][$key]->setValues($this->request->getParameters());
                    }
                } else {
                    $_form['form']->setValues($request->getParameters());
                }
            }
        }
    }

    /**
     * Uzivatelska validace formulare
     *
     * @param HttpRequest $request
     */
    protected function customValidate(HttpRequest $request)
    {
    }

    /**
     * Validates form
     *
     * @param HttpRequest $request
     * @return boolean
     */
    protected function validateForms(HttpRequest $request)
    {
        $forms = $this->formDefinitions->getForms();
        $ret = true;
        if (!empty($forms) && is_array($forms)) {
            foreach ($forms as $key => $_form) {
                /** @var Form[] $_form */
                $_form['form']->validate();
                if ($_form['form']->hasErrors() || $_form['form']->hasFormErrors()) {
                    $ret = false;
                }
            }
        }
        return $ret;
    }

    /**
     * provadi se pred zobrazovanim formulare
     * do ModelAndView ulozi potrebna data pro zobrazeni formulare
     * @return ModelAndView
     */
    abstract protected function loadData(HttpRequest $request, ModelAndView $mav);

    /**
     * provede se v pripade, ze validace formulare probehla v poradku
     *
     * @return ModelAndView
     */
    abstract protected function onSubmit(HttpRequest $request, ModelAndView $mav);

    /**
     * Nastavi fomulare do view<br>
     * Pokud se bude jednat o akci po odeslani formulare, nasatvi hodnoty z POSTu
     *
     * @param ModelAndView $mav
     * @return ModelAndView
     */
    protected function setFormsToView(ModelAndView $mav)
    {
        $_forms = $this->formDefinitions->getForms();
        if (!empty($_forms) && is_array($_forms)) {
            /** @var Form $form */
            foreach ($_forms as $key => $_form) {
                $mav->putParameter($_form['viewKey'], $_form['form']);
            }
        }
        return $mav;
    }

    /**
     * Only wrapper for setViewName - back compatibility
     *
     * @param string $viewName
     */
    public function setView($viewName)
    {
        $this->setViewName($viewName);
    }

    /**
     *
     * @param string $viewName
     */
    public function setViewName($viewName)
    {
        $this->viewName = $viewName;
    }

    public function getViewFormName()
    {
        return $this->viewFormName;
    }

    public function setViewFormName($viewFormName)
    {
        $this->viewFormName = $viewFormName;
    }

    public function getViewSuccessName()
    {
        return $this->viewSuccessName;
    }

    public function setViewSuccessName($viewSuccessName)
    {
        $this->viewSuccessName = $viewSuccessName;
    }
}
