<?php

namespace IZON\MVC\Context;

use IZON\MVC\HttpSession;
use IZON\MVC\PageInfo;

/**
 * context specific for web
 * contains PageInfo of current page, ...
 *
 * @author IZON s.r.o. <info@izon.cz>
 * @copyright Copyright 2017, IZON s.r.o.
 *
 * @package IZON\MVC\Context
 */
class WebContext extends Context
{
    /**
     * @var PageInfo
     */
    protected $pageInfo;


    /// generated constructor
    public function __construct(HttpSession $session, PageInfo $pageInfo)
    {
        parent::__construct($session);
        $this->pageInfo = $pageInfo;
    }

    public function getContextId()
    {
        return "web";
    }


    /// generated getter and setters
    public function getPageInfo()
    {
        return $this->pageInfo;
    }

    public function setPageInfo(PageInfo $pageInfo)
    {
        $this->pageInfo = $pageInfo;
    }
}
