<?php

namespace IZON\MVC\Exceptions\Handlers;

use Exception;
use IZON\Logs\LogLevel;
use IZON\MVC\Exceptions\AccessForbiddenException;
use IZON\MVC\HttpRequest;
use Throwable;
/**
 * @deprecated will be removed in version 4.5, serves only for backward compatbility to not break webs with 4.4 version and without config for ExceptionHandlers
 * Handles not accessable page request
 */
class OldAccessForbiddenExceptionHandler implements IAppExceptionHandler {
    
    protected $htmlToShow;

    /**
     * PageNotFoundExceptionHandler constructor.
     * @param string $htmlToShow - string absolute path (form htdocs) to PageNotFound Page (file)
     */
    public function __construct($htmlToShow) {
        $this->htmlToShow = $htmlToShow;
    }


    public function getLogLevel() {
        return LogLevel::INFO;
    }

    public function handleException(Throwable $exception, ?HttpRequest $request) {
        header($_SERVER['SERVER_PROTOCOL'].' 403 Forbidden');
        require $this->htmlToShow;
    }

    public function isFor(\Throwable $exception) {
        return $exception instanceof AccessForbiddenException;
    }
}
