<?php

namespace IZON\MVC\Controllers;

use Exception;
use \IZON\MVC\Controller;
use \IZON\MVC\HttpRequest;
use \IZON\MVC\ModelAndView;
use IZON\Forms\FormDefinition;

/**
 * @deprecated use FormSet instead
 * controller that calls view with name $viewName
 */
abstract class FormController implements Controller {
    protected $viewName = NULL;
    protected $viewFormName = NULL;
    protected $viewSuccessName = NULL;
    /**
     *
     * @var FormDefinition 
     */
    protected $formDefinitions;
    /**
     *
     * @var HttpRequest
     */
    protected $request;
    protected $redirectOnSuccess = false;
    public $hasFormError = false;

    public function __construct(array $params = array()) {
        $this->formDefinitions = new \IZON\Forms\FormDefinition();
    }

    /**
     * Default crossroads for from actions ie:<br>
     * for load form trigger loadData method<br>
     * for submitted form 
     * - succes: trigger loadData, setDataFromPost and onSubmit methods
     * - error: trigger loadData and setDataFromPost methods
     * 
     * @param HttpRequest $request
     * @return ModelAndView
     */
    public final function execute(HttpRequest $request) {
        $this->request = $request;
        //echo '<pre>'.print_r($_POST, true).'</pre><br>';
        $this->loadFormDefinitions();

        if($this->isFormSubmit()) {
            $this->executePreSubmit($request);
            $this->setDataFromPost($request);
            $this->customValidate($request);
            if($this->validateForms($request)) {
                // validace probehla v poradku
                $mav = new ModelAndView($this->viewSuccessName);
                $mav = $this->loadData($request, $mav);
                $this->setDataFromPost($request);
                $mav = $this->onSubmit($request, $mav);
            } else {
                $this->hasFormError = true;
                // byla zaznamenana chyba formulare
                $mav = new ModelAndView($this->viewFormName);
                $mav = $this->loadData($request, $mav);
                $this->setDataFromPost($request);
            }
        } else {
            $mav = new ModelAndView($this->viewFormName);
            $mav = $this->loadData($request, $mav);
        }
        $mav = $this->setFormsToView($mav);
        return $mav;
    }

    /**
     * Nastavi fomulare do view<br>
     * Pokud se bude jednat o akci po odeslani formulare, nasatvi hodnoty z POSTu
     * 
     * @param ModelAndView $mav
     * @return ModelAndView
     */
    protected function setFormsToView(ModelAndView $mav) {
        $_forms = $this->formDefinitions->getForms();
        if(!empty($_forms) && is_array($_forms)) {
            /* @var $form \IZON\Forms\Form */
            foreach($_forms as $key => $_form) {
                $mav->putParameter($_form['viewKey'], $_form['form']);
            }
        }
        return $mav;
    }

    /**
     * Sets data from HttpRequest to form defined in $ths->formDefinitions
     * 
     * @param HttpRequest $request
     */
    protected function setDataFromPost(HttpRequest $request) {
        $forms = $this->formDefinitions->getForms();
        if(!empty($forms) && is_array($forms)) {
            /* @var $form \IZON\Forms\Form */
            foreach($forms as $key => $_form) {
                if(is_array($_form['form'])) {
                    foreach($_form['form'] as $key => $value) {
                        $_form['form'][$key]->setValues($this->request->getParameters());
                    }
                } else {
                    $_form['form']->setValues($request->getParameters());
                }
            }
        }
    }

    /**
     * Validates form
     * 
     * @param HttpRequest $request
     * @return boolean
     */
    protected function validateForms(HttpRequest $request) {
        $forms = $this->formDefinitions->getForms();
        $ret = true;
        if(!empty($forms) && is_array($forms)) {

            foreach($forms as $key => $_form) {
                /* @var \IZON\Forms\Form[] $_form */
                $_form['form']->validate();
                if($_form['form']->hasErrors() || $_form['form']->hasFormErrors()) {
                    $ret = false;
                }
            }
        }
        return $ret;
    }

    /**
     * 
     * @param string $viewName
     */
    public function setViewName($viewName) {
        $this->viewName = $viewName;
    }

    /**
     * Only wrapper for setViewName - back compatibility
     * 
     * @param string $viewName
     */
    public function setView($viewName) {
        $this->setViewName($viewName);
    }

    /**
     * Uzivatelska validace formulare
     * 
     * @param HttpRequest $request
     * @return boolean
     */
    protected function customValidate(HttpRequest $request) {
        
    }

    /**
     * Definice formularu
     */
    protected abstract function loadFormDefinitions();

    /**
     * provadi se pred zobrazovanim formulare
     * do ModelAndView ulozi potrebna data pro zobrazeni formulare
     * @return ModelAndView
     */
    protected abstract function loadData(HttpRequest $request, ModelAndView $mav);

    /**
     * provede se v pripade, ze validace formulare probehla v poradku
     * 
     * @return ModelAndView
     */
    protected abstract function onSubmit(HttpRequest $request, ModelAndView $mav);

    /**
     * rozpoznava jestli se jednalo o odeslani formulare
     * odeslani formulare je to pouze pokud je v _REQUEST nasatavena hodnota action na post
     * da se prepsat v podtridach
     */
    protected function isFormSubmit() {
        return $this->request->getParameter("formAction") == "post";
    }

    public function getViewFormName() {
        return $this->viewFormName;
    }

    public function getViewSuccessName() {
        return $this->viewSuccessName;
    }

    public function setViewFormName($viewFormName) {
        $this->viewFormName = $viewFormName;
    }

    public function setViewSuccessName($viewSuccessName) {
        $this->viewSuccessName = $viewSuccessName;
    }

    /**
     * Spusti se jeste pred zapocetim validace - vyuzije se, <br>
     * pokud je treba data z formulare nejak upravit jeste pred tim, nez se zacne s validaci
     * 
     * @param HttpRequest $request
     */
    protected function executePreSubmit(HttpRequest $request) {
        
    }

}
