<?php

namespace IZON\MVC;

use Exception;

/**
 * slouzi pro obshuhu http session
 * jeji inicializaci zamceni, odemceni a zistaki parametru z ni
 */
class HttpSession {
    
    /**
     * @var integer how many times session start was requested
     */
    protected $startSessionNumber = 0;
    
    /**
     * nastartuje session, aby se nabindovala na nejake sessionid
     * a nastavi, aby se pri dalsim volani session_start neposilalo cookie
     */
    public function init() {
        session_start();
        session_write_close();
        # disable reseanding session cookie and so on
        # info https://stackoverflow.com/questions/12315225/reopening-a-session-in-php
        ini_set('session.use_only_cookies', false);
        ini_set('session.use_cookies', false);
        ini_set('session.use_trans_sid', false);
        ini_set('session.cache_limiter', null);
    }
    
    /**
     * uzamce session pro paramelne volane scripty
     */
    public function lock() {
        if( $this->startSessionNumber == 0) { // uz byla session jednou ptevrena
            // nemusi by podporovano @ini_set('session.use_cookies', 0), zamezit aby posilalo nekolikrat
            session_start();
        }
        $this->startSessionNumber++;
    }
    
    /**
     * odemce session pro ostatni volani skriptu
     */
    public function unlock() {
        if( session_status() == PHP_SESSION_NONE ) {
            throw new Exception("Can't unlock session. Session in not opened");
        }
        if( $this->startSessionNumber == 1) { // session je otevrena jen 1x
            session_write_close();
        }
        $this->startSessionNumber--;
    }
    
    /**
     * vraci parametr ze session, neresi zamikani a odemikani session
     */
    public function getParameter($name) {
        $value = NULL;
        if( isset($_SESSION[$name]) ) {
            $value = $_SESSION[$name];
        }
        return $value;
    }

    /**
     * ulozi parametr do session, neresi zamikani a odemikani session
     */
    public function setParameter($name, $value) {
        $_SESSION[$name] = $value;
    }
    
    /**
     * ulozi parametr do session, neresi zamikani a odemikani session
     */
    public function removeParameter($name) {
        unset($_SESSION[$name]);
    }
}
