<?php

namespace IZON\MVC\Exceptions\Handlers;

use Exception;

use \IZON\Logs\LogLevel;
use \IZON\MVC\Exceptions\PageNotFoundException;

/**
 * Handles if page is not found
 */
class PageNotFoundExceptionHandler implements AppExceptionHandler {
    
    protected $htmlToShow;

    /**
     * PageNotFoundExceptionHandler constructor.
     * @param string $htmlToShow - string absolute path (form htdocs) to PageNotFound Page (file)
     */
    public function __construct($htmlToShow) {
        $this->htmlToShow = $htmlToShow;
    }


    public function getLogLevel() {
        return LogLevel::WARN;
    }

    public function handleException(Exception $exception) {
        header($_SERVER['SERVER_PROTOCOL'].' 404 Not Found');
        require $this->htmlToShow;
    }

    public function isFor(Exception $exception) {
        return $exception instanceof PageNotFoundException;
    }
}
