<?php

namespace IZON\MVC\Json;

use Exception;

/**
 * jsonova odpoved
 */
class JsonResponse {
    
    const RESULT_OK = "ok";
    
    const RESULT_ERROR = "error";
    
    /**
     * @var string typ odpovedi, na jejim zaklade se potm zpracovavaji nastavena data
     */
    public $result;
    
    /**
     * @var mixed 
     */
    public $data;

    /**
     * @var string error message 
     */
    public $error;
    
    /**
     * vytvari odpoved kdy vse probehlo bez problemu
     * @param mixed $data data prevadena do jsonu ulozena pod klicem data
     */
    public static function createResponse($data) {
        $response = new JsonResponse();
        $response->result = self::RESULT_OK;
        $response->data = $data;
        
        return $response;
    }
    
    /**
     * doslo k obecne chybe, chybova hlaska je ulozena pod klicem 
     * @param string $errorMessage text chyby error
     */
    public static function createErrorResponse($errorMessage) {
        $response = new JsonResponse();
        $response->result = self::RESULT_ERROR;
        $response->error = $errorMessage;
        
        return $response;
    }
    
    /**
     * obecna jsonov odpoved kde je mozne si poslat jakekolidata
     * @param string $result typ odpovedi
     * @param array $data data predavana odpovedi, jdotlive klice se navazou do obektu
     * @throws Exception
     */
    public static function createCustomResponse($result, array $data) {
        $response = new JsonResponse();
        $response->result = $result;
        foreach($data as $key => $value) {
            if($key == "result") {
                throw new Exception("Data nesmi obsahovat klic result, ktery se rezervovan pro predani typu odpovedi");
            }
            $response->$key = $value;
        }
        
        return $response;
    }
}
