<?php

namespace IZON\MVC\Views;

use Exception;

use IZON\MVC\Views\PHPView;
use IZON\Logs\Logger;

/**
 * trida renderujici view, resici cachovani rendrovani view, skladajici view 
 * z jednotlivych casti, ...
 * jednotliva view jsou ulozena v adresarich
 * pri devel modu naincluduje nekde dole ve strance misto na debug informace
 *
 * @author David Dryml <dryml@izon.cz>
 * @copyright Copyright 2009, HI Software s.r.o.
 *
 * @version v1.0 rc
 *
 * @package MVC
 */
class PHPLayoutView extends PHPView {

    /**
     * suffix of template part file
     */
    const PART_SUFFIX = ".tmpl.php";
    
    /**
     * suffix of layout file
     */
    const LAYOUT_SUFFIX = ".lay.php";
    
    /**
     * cesty k adresari s views pro jednotlive moduly 
     * @var array 
     */
    protected $layoutPartsDirs;


    /**
     * vytvari view podle zadaneho jmena a predava mu parametry
     */
    function __construct($viewPath, $layoutPartsDirs) {
        parent::__construct($viewPath);
        
        $this->layoutPartsDirs = $layoutPartsDirs;
        
        $this->log = Logger::getLogger(self::class);
    }


    /**
     * provede renderovani soucasti graficleho rozhrani
     */
    function renderLayoutPart($partName, $sameDirectory = false) {
        if( $sameDirectory ) {
            $viewsDir = $this->layoutPartsDirs[0];
            $localeTag = $this->getLocale()->toLocaleTag();
            
            $partFilePath = $viewsDir ."/". $partName .".". $localeTag . self::PART_SUFFIX;
            if( file_exists($partFilePath) ) { // use locale specific view
                require $partFilePath;
                return;
            }
            $partFilePath = $viewsDir ."/". $partName . self::PART_SUFFIX;
            if( !file_exists($partFilePath) ) { // use view
                throw new Exception($partName ." doesn't exist in dir ". $viewsDir);
            }
            require $partFilePath;
        } else {
            $partFilePath = $this->findLayoutPartFilePath($partName);
            if( $partFilePath == NULL ) {
                throw new Exception($partName ." doesn't exist");
            }
            
            require $partFilePath;
        }
    }

    /**
     * @param string $partName
     * @return string absolute path
     */
    private function findLayoutPartFilePath($partName) {
        $this->log->info("Calling findLayoutPartFilePath with parameter: [$partName]");
        
        $localeTag = $this->getLocale()->toLocaleTag();
        foreach($this->layoutPartsDirs as $layoutPartDir) {
            $templatePartFilePath =  $layoutPartDir ."/". $partName .".". $localeTag . self::PART_SUFFIX;
            if( file_exists($templatePartFilePath) 
                && is_file($templatePartFilePath) ) {
                $this->log->info("Found template $templatePartFilePath");
                return $templatePartFilePath;
            }
            
            $templatePartFilePath =  $layoutPartDir ."/". $partName . self::PART_SUFFIX;
            if( file_exists($templatePartFilePath) 
                && is_file($templatePartFilePath) ) {
                $this->log->info("Found template $templatePartFilePath");
                return $templatePartFilePath;
            }
        }
        
        throw new Exception("Layout part ". $partName ." not found");
    }
}
