<?php

namespace IZON\MVC\Exceptions\Handlers;

use Exception;
use Throwable;

use \IZON\Logs\LogLevel;
use \IZON\MVC\Exceptions\InternalServerErrorException;

/**
 * Handles if page is not found
 */
class InternalServerErrorExceptionHandler implements AppExceptionHandler {
    
    protected $htmlToShow;

    /**
     * InternalServerErrorExceptionHandler constructor.
     * @param string $htmlToShow - string absolute path (form htdocs) to InternalServerError Page (file)
     */
    public function __construct($htmlToShow) {
        $this->htmlToShow = $htmlToShow;
    }


    public function getLogLevel() {
        return LogLevel::ERROR;
    }

    public function handleException(Exception $exception) {
        header($_SERVER['SERVER_PROTOCOL'].' 500 Internal Server Error');
        require $this->htmlToShow;
    }

    public function isFor(Exception $exception) {
        return $exception instanceof Exception // for php5.6 compatibility
                || $exception instanceof Throwable;
    }
}
