<?php

namespace IZON\MVC\Exceptions\Handlers;

use Exception;
use IZON\MVC\ModelAndView;


/**
 * handler pro zpracovani nejakych vyjimek, krere protecou az do aplikace
 */
interface AppExceptionHandler {
    
    /**
     * 
     * @param Exception $exception vyjimka, u ktere se ma zjistit, jestli ze ma zpracovat
     * @return boolean true pokud se ma vyjimka zpracovat timto handlerem
     */
    public function isFor(Exception $exception);
    
    /**
     * @return int log level to log this exception from LogLevel
     */
    public function getLogLevel();
    
    /**
     * zpracuj vyjimku
     * @param \Exception $exception
     * @return NULL|ModelAndView returns null, if handler rendered result, ModelAndView if fall to view is needed
     * 
     */
    public function handleException(Exception $exception);
}
