<?php

namespace IZON\MVC\RPC\JsonRPC;

use \JsonSerializable;

/**
 * Normalni odpover JsonRPC
 */
class Response implements JsonSerializable {
    
    protected $jsonrpc = "2.0";
    
    protected $result; 
    
    protected $id;
    
    function __construct($result, $id) {
        $this->result = $result;
        $this->id = $id;
    }

    function getJsonrpc() {
        return $this->jsonrpc;
    }

    function getResult() {
        return $this->result;
    }

    function getId() {
        return $this->id;
    }

    public function jsonSerialize() {
        return [
            'jsonrpc' => $this->jsonrpc,
            'result' => $this->result,
            'id' => $this->id,
        ];
    }
}
