<?php

namespace IZON\MVC\Interceptors;

use \IZON\MVC\HttpRequest;
use \IZON\MVC\ModelAndView;

/**
 * trida Interceptor
 *
 * @author David Dryml <dryml@izon.cz>
 * @copyright Copyright 2009, HI Software s.r.o.
 *
 * @version v1.0 rc
 *
 * @package MVC
 */
interface Interceptor {

    /**
     * vyvolava se po volani view, slouzi predevsim k uklidu alokovanych zdroju atd.
     * @param HttpRequest $_REQUEST pole request obsahujici parametry z requestu
     * @param Object $exception vyjimka pokud byla nejaka vyvolanna, jinak null
     *
     * @param HttpRequest $request
     * @param mixed $exception
     * @return mixed
     */
    public function afterCompletion(HttpRequest $request, $exception);

    /**
     * provede se po vyvolani controlleru ale pred vyvolanim view<br /><br />
     *
     * @param HttpRequest $request
     * @param ModelAndView $model
     */
    public function postHandle(HttpRequest $request, ModelAndView $model);

    /**
     * provadi se pred vyvolanim controlleru
     * muze vratit informace ktere mohou slouzit k presmerovani nebo dalsim akcim
     *
     * @param HttpRequest $request
     * @return NULL|PreHandleResult default return value is null
     */
    public function preHandle(HttpRequest $request);
}