<?php

namespace IZON\MVC\Routers;

use IZON\MVC\Context\Context;

/**
 * informace kam se ma adresa routovat
 */
class RouteInfo {

    /**
     * @var integer jaky se ma provest redirect: 0 je zadny, jinak 301 nebo 302, pokud je redirect tak pouzij url jako adresu kam presmerovat
     */
    protected $redirect = 0;

    /**
     * url, ktere bylo pouzito
     * @var string
     */
    protected $url;

    /**
     * id controlleru, ktery se ma volat
     * @var string
     */
    protected $contrlollerId;

    /**
     * naze metody, ktera se ma volat
     * @var string
     */
    protected $methodName;

    /**
     * pattern, ktery odpovida dane adrese
     * @var string
     */
    protected $pattern;

    /**
     * parametry, ktere byly z adresy extrahovany
     * @var string
     */
    protected $parameters = [];

    /**
     * jake interceptory se maji pri vykonavani zavolat,
     * contains class of interceptor or indetifier to search in DI container
     * @var array
     */
    protected $interceptors = [];

    /**
     * @var Context
     */
    protected $context;


    function getURL() {
        return $this->url;
    }

    function setURL($url) {
        $this->url = $url;
    }

    /// geberated getters and setters


    function getContrlollerId() {
        return $this->contrlollerId;
    }

    function getMethodName() {
        return $this->methodName;
    }

    function getPattern() {
        return $this->pattern;
    }

    function getParameters() {
        return $this->parameters;
    }

    function setContrlollerId($contrlollerId) {
        $this->contrlollerId = $contrlollerId;
    }

    function setMethodName($methodName) {
        $this->methodName = $methodName;
    }

    function setPattern($pattern) {
        $this->pattern = $pattern;
    }

    function setParameters($parameters) {
        $this->parameters = $parameters;
    }

    function getInterceptors() {
        return $this->interceptors;
    }

    function setInterceptors(array $interceptors) {
        $this->interceptors = $interceptors;
    }

    function addInterceptor($interceptor) {
        $this->interceptors[] = $interceptor;
    }

    function addInterceptors($interceptors) {
        $this->interceptors = array_merge($this->interceptors, $interceptors);
    }

    function getRedirect() {
        return $this->redirect;
    }

    function setRedirect($redirect) {
        $this->redirect = $redirect;
    }

    function getContext() {
        return $this->context;
    }

    function setContext(Context $context) {
        $this->context = $context;
    }

    function __toString() {
        return print_r((array)$this, true);
    }
}
