<?php

/*
 * pomocne funkce pro zobrazovani view a jeho skladani z casti
 */

namespace PHPView;

use IZON\MVC\PageInfo;
use IZON\Utils\Locale;

use IZON\MVC\FlashMessage;

use IZON\MVC\View\PHPView;

/**
 * provede vlozeni soucasti layoutu do pozadovaneho mista, kde se tato fce vola
 * @var string $partName jak se dana cast jmenuje
 * @var boolean $required jetli musi byt primo v danem adresari sablony
 */
function insertLayoutPart($partName, $required = FALSE) {
    $view = PHPView::getApplicationView();
    //echo '<pre>xxx' . print_r($view, true) . '</pre><br>';

    $view->renderLayoutPart($partName);
}

/**
 * vrati nejaky z parametru predanych do view
 */
function getParameter($paramName) {
    $view = PHPView::getApplicationView();
    return $view->getParameter($paramName);
}

/**
 * Vrati \IZON\MVC\FlashMessage na zaklade jeji id a vymaze ji z registru<br>
 * Pokud nebude id zadano, veme se prvni ze seznamu zprav a seznam se komplet vyprazdni
 *
 * @param string $id
 * @return  FlashMessage|null
 */
function getFlashMessage($id = NULL) {
    $ret = null;
    $context = getFlashMessagesContext();
    // otevri session jestli jeste nebyla otevrena
    $sessionNotStarted = session_status() == PHP_SESSION_NONE;
    if ($sessionNotStarted) { // jeste nebyla nastartovana sessiona, nastartovat
        // server nemusi byt schopen nastavit ini_set('session.use_cookies', 0), aby se cookie se session id posilalo jen jednou pri initu aplikace
        @session_start();
    }

    if (is_null($id)) {
        $swap = getFlashMessages();
        if (!empty($swap) && is_array($swap)) {
            $ret = reset($swap);
            unset($_SESSION['flashMessages'][$context]);
        }
    } elseif (array_key_exists($id, getFlashMessages())) {
        $ret = getFlashMessages()[$id];
        unset($_SESSION['flashMessages'][$context][$id]);
    }

    if ($sessionNotStarted) { // pred timto otevrenim session jeste nebyla session nastartovana, tak je ji mozno zavrit
        session_write_close();
    }

    return $ret;
}

/**
 * Zjisti, jestli je zaregistrovana nejaka (v pripade zadaneho id konkretni) zprava k zobrazeni
 *
 * @param string $id
 * @return boolean
 */
function hasFlashMessage($id = NULL) {
    if (is_null($id)) {
        $swap = getFlashMessages();
        if (!empty($swap) && is_array($swap)) {
            return true;
        }
    } else {
        return array_key_exists($id, getFlashMessages());
    }
    return false;
}

/**
 * Return context of flash messages
 *
 * @return string [web|admin]
 */
function getFlashMessagesContext() {
    $context = 'web';
    if (array_key_exists('adminLoggedAdminUser', $_SESSION)) {
        $context = 'admin';
    }
    return $context;
}

/**
 * Vrati vescky zaregistrovane flashmessages
 *
 * @return array
 */
function getFlashMessages() {
    $context = getFlashMessagesContext();
    if (isset($_SESSION['flashMessages'][$context])) {
        return (array)$_SESSION['flashMessages'][$context];
    } else {
        return [];
    }
}

/**
 * vrati absolutni cestu (od korene webu) zadanemu URL
 * @param string $relativeURL
 */
function getURL($relativeURL) {
    // TODO: nahradit necim nezavisejicim na WEB_ROOT_DIR
    return "/" . $relativeURL;
}

/**
 * Prida za nazev souboru za otaznik timestamp jeho posledni modifikace
 * @param string $file
 * @return string
 */
function getTimeStampedURL($file) {
    $_file = __BASE_DIR__ . '/www/' . str_replace('../', '', $file);
    if (is_file($_file)) {
        $time = filemtime($_file);
        return '/' . $file . '?' . ($time ? $time : time());
    } else {
        return '/' . $file;
    }
}
/**
 * Return relative path for file with last change timestamp - if file exists
 * @param string $file
 * @return string
 */
function getAdminTimeStampedURL($file) {
    $_file = __BASE_DIR__ . '/app/' . str_replace('../', '', $file);
    if (is_file($_file)) {
        $time = filemtime($_file);
        return '/' . $file . '?' . ($time ? $time : time());
    } else {
        return '/' . $file;
    }
}


/**
 * vrati odkaz odpovidajici controlleru se zadanimy parametry
 * @param string $controllerId id controlleru z DI containeru, ktery se ma zaolat
 * @param array $params parametry, potrebne k doplneni controleru
 * @param string $methodName metoda controlleru, ktera se ma zavolat
 * @param string|Locale $locale locale string used to define which locale version of web to show
 */
function getControllerURL($controllerId, array $params = [], $methodName = NULL, $locale = NULL) {
    $view = PHPView::getApplicationView();
    if ($locale == NULL) {
        $locale = $view->getLocale();
    } else if (is_string($locale)) {
        $locale = Locale::forLocaleTag($locale);
    }
    //    var_dump($locale);
    $url = $view->getRouter()->findURL($controllerId, $params, $methodName, $locale);
    return str_replace("&", "&amp;", $url);
}

/**
 * formats number for better number view
 * @param float $amount
 *
 * FIXME: pridat fomatovani na zaklade locale
 */
function formatNumber($amount, Locale $locale = NULL) {
    $round = 0;
    // TODO: pridat rounding
    $str = number_format($amount, $round, ',', '&nbsp;');
    return $str;
}

/**
 * returns locaje class containing language and country part
 * @return Locale
 */
function getLocale() {
    $view = PHPView::getApplicationView();
    return $view->getLocale();
}

/**
 *
 * @return Locale
 */
function getLocaleEx() {
    return \PHPView\getParameter(\IZON\DBLocale\Interceptor\LocaleInterceptor::AVAILABLE_AS);
}

/**
 * TODO: asi je pozustatek statreho systemu, pri zmene co rozbiji rozhrani odstranit
 * nacte soubory z adresare
 * $params['class'] - navratova trida pro soubor, jako parametry konstruktoru budou vloženy adresar a nazev souboru
 * $params['extensionOnly'] - budou nacteny pouze soubory s uvedenou priponou, nebude - li vyplneno, nactou se vsechny soubory
 *
 * @param string $dir cesta k adresari
 * @param array $params
 */
function loadFilesFromDir($dir, $params = array()) {
    $d = dir($dir);
    if ($dir[strlen($dir) - 1] != '/') {
        $dir .= '/';
    }
    $ret = [];
    while (false !== ($entry = $d->read())) {

        if (is_file($dir . $entry)) {
            if (!empty($params['extensionOnly']) && is_array($params['extensionOnly'])) {
                if (!in_array(pathinfo($entry, PATHINFO_EXTENSION), $params['extensionOnly'])) {
                    continue;
                }
            }
            $ret[] = (!empty($params['class']) ? new $params['class']($dir, $entry) : array('dir' => $dir, 'file' => $entry));
        }
    }
    $d->close();
    return $ret;
}

/**
 * Render js a css 
 *
 * $data = either one dimensional field with paths to files, or<br>
 * field fields, where nested fierld has structure<br>
 * $script[external] - jedna se o externi js/css - pokud neni, netreba zadavat<br>
 * $script[src] - url, ze ktere se ma script natahnout<br>
 * pro css je jeste dostupny $script[media] - pro jaky typ media budou css pouzita - nepovinny parametr
 * <br><br>
 * For example: $data = [['external'=>true, 'src' => 'http://www.something-somewher.com/script.js']]<br>
 * $data = ['js/app.js', 'js/common.js', 'js/jquery.js']<br>
 *
 *
 * @param array $data
 * @param string $type [js|css]
 * @param string $context [web|admin]
 */
function insertScripts(array $data, $type, $context = 'web') {
    $urlFunction = '\PHPView\getTimeStampedURL';
    if($context == 'admin') {
        $urlFunction = '\PHPView\getAdminTimeStampedURL';
    }
    if (is_array($data) && !empty($data)) {
        foreach ($data as $key => $value) {
            if (empty($value)) {
                continue;
            }
            // little bit hack for admin css and js files
            if (!is_array($value) && $context == 'admin') {
                $value = ['src' => $value];
            }
                
            if (!is_array($value)) {
                if ($type == 'js') {
                    includeScripts([$value]);
                } elseif ($type == 'css') {
                    includeStyles([$value]);
                }
            } else {
                if ($value['external']) {
                    if ($type == 'js')
                        echo '<script type="text/javascript" src="' . $value['src'] . '"></script>' . LF;
                    elseif ($type == 'css')
                        echo '<link href="' . $value['src'] . '" rel="stylesheet" type="text/css"' . ($value['media'] != '' ? ' media="' . $value['media'] . '"' : '') . ' />' . LF;
                } else {
                    if ($type == 'js') {
                        echo '<script type="text/javascript" src="' . $urlFunction($value['src']) . '"></script>' . LF;
                    } elseif ($type == 'css') {
                        echo '<link href="' . $urlFunction($value['src']) . '" rel="stylesheet" type="text/css"' . ($value['media'] != '' ? ' media="' . $value['media'] . '"' : '') . ' />' . LF;
                    }
                }
            }
        }
    }
}

function includeScripts(array $scripts, $type = "js") {
    $view = PHPView::getApplicationView();
    foreach ($scripts as $script) {
        $staticFileURL = $view->getStaticFileURL($script);
        echo '<script type="text/javascript" src="' . $staticFileURL . '"></script>' . PHP_EOL;
    }
}

function includeStyles(array $styles, $type = "css") {
    $view = PHPView::getApplicationView();
    foreach ($styles as $style) {
        $staticFileURL = $view->getStaticFileURL($style);
        echo '<link href="' . $staticFileURL . '" rel="stylesheet" type="text/css"' . ($value['media'] != '' ? ' media="' . $value['media'] . '"' : '') . ' />' . PHP_EOL;
    }
}

function includeSvg($svg) {

}

/**
 * Returns svg file content
 *
 * @param string $name svg file name
 * @param string $path path to svg file, default is htdocs/www/images/svg
 * @return string
 */
function insertSvg($name, $path = 'www/images/svg') {
    return file_get_contents(__BASE_DIR__ . '/' . $path . '/' . $name . '.svg');
}


/**
 * Return color picker for forms usage
 *
 * @param array $param
 * @return string
 */
function getColorRadio($param) {

    return 'HTML';

}

/**
 * Return DropZone area
 *
 * @param array $param
 */
function getDropzoneField($param) {

}

/**
 * Return image url for source path or Image object
 * @param [\IZON\IO\Image|path_to_file] $sourceImage source Image Object or path to image file with first "/"
 * @param array $parameters parameters for resizing of image, supported settings:<br>
 * width => integer, <br>height => integer, <br>type => [cover|contain], default is contain, <br>quality = number, default = 90<br>
 * for example: ["width" => 1234, "height" => 1234, "type" => "contain"]
 *
 * @return string
 */
function getThumbnail($sourceImage, array $parameters = []) {
    /* @var $THUMBER \IZON\Thumber\Thumber */
    $THUMBER = \PHPView\getParameter(\IZON\Thumber\Thumber::AVAILABLE_AS);
    try {
        $src = $THUMBER->getImageURL($sourceImage, $parameters);
    } catch (\Exception $exc) {
        $src = $THUMBER->getImageURL(\IZON\MVC\Config::getValue('no-image-location'), $parameters);
    }
    return \PHPView\getURL($src);
}

/**
 * Only wrapper for getThumbnail, for more detail see there
 * @param [\IZON\IO\Image|path_to_file] $sourceImage source Image Object or path to image file with first "/"
 * @param array $parameters parameters for resizing of image, supported settings:<br>
 * width => integer, <br>height => integer, <br>type => [cover|contain], default is contain, <br>quality = number, default = 90, max is 100 - create image without any compression<br>
 * for example: ["width" => 1234, "height" => 1234, "type" => "contain"]
 * @return string
 */
function getThumb($sourceImage, array $parameters = []) {
    return getThumbnail($sourceImage, $parameters);
}

/**
 * Retruns \IZON\MVC\PageInfo object
 *
 * @return \IZON\MVC\PageInfo
 */
function getPageInfo() {
    $pageInfo = \PHPView\getParameter(\IZON\MVC\PageInfo::PAGE_INFO_INDENTIFIER);
    return $pageInfo;
}

/**
 * Check if actual page controller is same like controllerId param
 * @param string $controllerId to check
 * @return bool True - yes is actual False - not actual
 */
function isControllerActualPageController($controllerId) {
    /** @var PageInfo $pageInfo */
    $pageInfo = \PHPView\getParameter(\IZON\MVC\PageInfo::PAGE_INFO_INDENTIFIER);
    if ($pageInfo->getControllerId() == $controllerId) {
        return true;
    }
    return false;
}
/**
 * Clear string from diacritics and other "dangerous" characters, uses \IZON\Utils\Slug()
 * 
 * @param string $string
 * @return string 
 */
function clearString($string) {
    return \IZON\Utils\Slug::createSlug($string);
}