<?php

namespace IZON\MVC\RPC\JsonRPC;

use Exception;

use \IZON\Admin\Services\SessionService;

use IZON\DI\Container;

use IZON\Logs\Logger;

use IZON\MVC\Controller;
use IZON\MVC\HttpRequest;


/**
 * TODO: asi nejlepe preposlat na JsonRPC view
 * 
 * controller for accessing services
 */
class JsonRPCController implements Controller {
    
    protected $rpcAccessControl = NULL;
    
    /**
     * containet
     * @var Container 
     */
    protected $container = NULL;
    
    /**
     * 
     * @var Logger 
     */
    protected $log = NULL;
    
    /**
     * 
     * @param \IZON\DI\Container $container
     * @param SessionService $sessionService
     */
    public function __construct($container,
                                SessionService $sessionService = NULL) {
        $this->sessionService = $sessionService; // not used
        $this->container = $container;
        
        // TODO: nastavovat z venku
        $accessConfig = require __BASE_DIR__ ."/config/rpc-access.php";
        $this->rpcAccessControl = new \IZON\MVC\RPCAccessControl($accessConfig);
        
        // sprovoznit logovani
        $this->log = Logger::getLogger(self::class);
    }
    
    public function execute(HttpRequest $request) {
        $parameters = $request->getParameters();
        $serviceId = $parameters["_SERVICE_ID"];
        unset($parameters["_SERVICE_ID"]);
        $method = $parameters["_METHOD"];
        unset($parameters["_METHOD"]);
        $id = $parameters["_REQUEST_ID"];
        unset($parameters["_REQUEST_ID"]);
        $passParams = $parameters["_PARAMS"];
        
        $this->log->info("Extracted setviceID = $serviceId and method = $method");
        
        $service = $this->container->get($serviceId);
        
        try {
            $reflectionClass = new \ReflectionClass($service);
            $this->log->info("Creating reflection class.");
            
            $reflectionMethod = $reflectionClass->getMethod($method);
            
            if( !$this->rpcAccessControl->canAccess($serviceId, $method, $parameters) ) {
                throw new Exception("Metoda $method servisu s id $serviceId není dostupna");
            }
            
            $this->log->info("Can acess metoda $method of service with id $serviceId.");
            
            if( !$reflectionMethod->isPublic() ) {
                throw new Exception("Metoda $method servisu s id $serviceId není public");
            }
            $this->log->info("Method $method of service with id $serviceId is public.");
            
            
            $result = $reflectionMethod->invokeArgs($service, $passParams);
            
            $response = new Response($result, $id);
            
//            echo '<pre>'.print_r( $response, true).'</pre><br>';
            
            header('Content-Type: application/json');
            echo json_encode($response);
            
            // TODO: zabalid odpved aodeslat
        } catch(\Exception $e) {
            $error = new ErrorResponse($e->getCode(), $e->getMessage(), $id);
            
            header('Content-Type: application/json');
            echo json_encode($error);
        }
    }
}
