<?php

namespace IZON\MVC\Locale;

use IZON\Utils\Locale;

/**
 * zjisti jake locale se ma pouzit z url
 */
interface LocaleResolver {
    
    /**
     * nastavi locale a vrati pouzivane locale
     * @param string $requestURL
     * @param array $requestParams
     * @return Locale Description
     */
    function resolveLocale($requestURL, $requestParams);
    
    /**
     * pokud je locale obsazeno v url tak tuto informaci odstrani pro vnitrni rozloznavani locale
     * @param string $requestURL
     * @param Locale $locale
     */
    function modifyRequestURL($requestURL, Locale $locale);
    
    /**
     * upravi url tak aby obsahovalo informaci o locale
     * @param string $requestURL
     * @param Locale $locale
     * @return string url s pridanymi informcemi o locale
     */
    public function modifyOutpultURL($requestURL, Locale $locale);
}
