<?php

namespace IZON\MVC\Interceptors;

use IZON\Utils\Locale;

/**
 * Result of prehandle function in Intereceptor
 */
class PreHandleResult {    
    
    /**
     * address tu redirect out of web
     * contains protpcol
     * @var string 
     */
    protected $redirectAddress = NULL;
    
    /**
     * specifies controller to redirect to
     * @var string 
     */
    protected $controllerId = NULL;
    
    /**
     * parameters used to generate redirect adderss
     * @var array 
     */
    protected $parameters = NULL;

    /**
     * @var string jaka metoda se ma volat 
     */
    protected $methodName = NULL;
    
    /**
     * @var Locale jake locale se ma zobrazit 
     */
    protected $locale = NULL;



    /**
     * 
     * @return boolean if redirect is requested
     */
    function isInternalRedirect() {
        return $this->controllerId != NULL;
    }
    
    /**
     * 
     * @return boolean if redirect is requested
     */
    function isExternalRedirect() {
        return $this->redirectAddress != NULL;
    }
    
    function getRedirectAddress() {
        return $this->redirectAddress;
    }

    function getControllerId() {
        return $this->controllerId;
    }

    function getParameters() {
        return $this->parameters;
    }
    
    function getMethodName() {
        return $this->methodName;
    }

    function getLocale() {
        return $this->locale;
    }
    
    /**
     * creates redirect to some internal controller
     * @param string $controllerId
     * @param array $parameters
     * @param string $methodName
     * @param Locale $locale
     * @return PreHandleResult
     */
    public static function getInternalRedirect($controllerId, array $parameters = [], $methodName = NULL, Locale $locale = NULL) {
        $preHandleResult = new PreHandleResult();
        
        $preHandleResult->controllerId = $controllerId;
        $preHandleResult->parameters = $parameters;
        $preHandleResult->methodName = $methodName;
        $preHandleResult->locale = $locale;
        
        return $preHandleResult;
    }
    
    /**
     * creates redirect to possibly external address or static site
     * @param string $redirectAddress
     * @return PreHandleResult
     */
    public static function getExternalRedirect($redirectAddress) {
        $preHandleResult = new PreHandleResult();
        
        $preHandleResult->redirectAddress = $redirectAddress;
        
        return $preHandleResult;
    }
}
