<?php

namespace IZON\MVC;

use \Exception;

use \IZON\Logs\Logger;

use \IZON\Admin\DI\ModulesAwareContainerBuilder;
use \IZON\Admin\DI\ModulesAwareContainer;

use \IZON\MVC\RPC\JsonRPC\Response;
use \IZON\MVC\RPC\JsonRPC\ErrorResponse;

/**
 * slouzi k exportovani service objektum a k rizeni pristupu k nim
 * 
 * komunikuje pomoci jsonrpc: http://www.jsonrpc.org/specification
 * pres http: http://www.simple-is-better.org/json-rpc/transport_http.html
 */
class JsonRPCService {
    
    /**
     * v jakem adresari se nachazi cela aplikace
     * @var string 
     */
    protected $baseDir = "";
    
    /**
     * v jakem akresari se nachazeji konfigy
     * @var string 
     */
    protected $configDir = '/config';
    
    /**
     * jaky stringem zacina konfiguracni soubor
     * @var string 
     */
    protected $configFilePrefix = "config";
    
    /**
    * v jakem adresari se nachazeji docasne soubory
    * @var string 
    */
    protected $tmpDir = '/tmp';
    
    /**
     * DI container z ktereho je mozne vytahovat controllery
     * @var Container 
     */
    protected $container = NULL;
    
    /**
     * klic pod kterym je ulozeno macineid
     * @var string 
     */
    protected $machineIdKey = 'MACHINE_ID';
    
    /**
     *
     * @var RPCAccessControl 
     */
    protected $rpcAccessControl;

    /**
     * 
     * @var Logger 
     */
    protected $log = NULL;
    

    public function __construct($baseDir) {
        $this->baseDir = $baseDir;
    }
    
    /**
     * provede inicializaci aplikace
     */
    public function init() {
        $builder = new ModulesAwareContainerBuilder();
        
        // inicializace konfigurace
        $this->initConfig($builder);
        
        // vytbori di container
        $this->container = $builder->build();
        
        // incializuje logger
        $this->container->get(\IZON\Admin\Config::INIT_LOGGER_IDENTIFIER);
        
        // sprovoznit logovani
        $this->log = Logger::getLogger(self::class);
        
        // inicializuje LocaleResolver
        // TODO: pridat moznost aby se dal nastavit z ccontaineru
        $this->localeResolver = new LocaleResolver();
        
        // nastaveni 
        $accessConfig = require $this->getAbsoluteConfigDir() ."/rpc-access.php";
        $this->rpcAccessControl = new RPCAccessControl($accessConfig);
    }
    
    /**
     * spusti zpracocani dotazu
     */
    public function dispatch() {
        throw new Exception("Cant be called.");
        try {
            if( $_SERVER['REQUEST_METHOD'] == 'POST') {
                $request_json = file_get_contents( 'php://input' );
                $servceId = $_REQUEST["serviceId"];
                $json = json_decode($request_json);
                
                $method = $json->method;
                $parameters = $json->params;
                $id = $json->id;
            } else if( $_SERVER['REQUEST_METHOD'] == 'GET') {
                $servceId = $_REQUEST["serviceId"];
                $method = $_REQUEST["method"];
                $parameters = json_decode( urldecode($_REQUEST["params"]) );
                $id = intval($_REQUEST["id"]);
            } else {
                throw new Exception("Unsupportrd method ". $_SERVER['REQUEST_METHOD']);
            }
            
            $this->log->info("Obtaining service $servceId from container");
            // TODO: test jestli existuje
            $service = $this->container->get($servceId);
            
            
            $reflectionClass = new \ReflectionClass($service);
            $reflectionMethod = $reflectionClass->getMethod($method);
            
            if( $this->rpcAccessControl->canAccess($servceId, $method, $parameters) ) {
                throw new Exception("Metoda $method servisu s id $servceId není dostupna");
            }
            if( !$reflectionMethod->isPublic() ) {
                throw new Exception("Metoda $method servisu s id $servceId není public");
            }
            
            if( is_object($parameters) ) { // jsou pojmenovane paremetry
                // vyfiltruje jen parametry, ktere metoda ma
                // TODO: rozhonout, jestli vyhlasovat chybu pokud je nejaka nesrovnalost 
                // TODO: provadet kontrolu a revod typu
                $passParams = [];
                foreach( $reflectionMethod->getParameters() as $reflectionParam ) {
                    /* @var $reflectionParam ReflectionParameter */
                    $name = $reflectionParam->getName();
                    if( isset($parameters->$name) ) {
                        $passParams[] = $parameters[$reflectionParam->$name];
                    } else {
                        $passParams[] = $reflectionParam->getDefaultValue();
                    }
                }
            } else if(is_array($parameters)) { // je normalni pole
                $passParams = [];
                $index = 0;
                foreach( $reflectionMethod->getParameters() as $reflectionParam ) {
                    /* @var $param ReflectionParameter */
                    if (isset($parameters[$index])) {
                        $passParams[] = $parameters[$index];
                    } else {
                        $passParams[] = $reflectionParam->getDefaultValue();
                    }
                    $index++;
                }
            } else {
                
            }

            $result = $reflectionMethod->invokeArgs($service, $passParams);
            
            $response = new Response($result, $id);
            
//            echo '<pre>'.print_r( $response, true).'</pre><br>';
            
            header('Content-Type: application/json');
            echo json_encode($response);
            
            // TODO: zabalid odpved aodeslat
        } catch(\Exception $e) {
            $error = new ErrorResponse($e->getCode(), $e->getMessage(), $id);
            
            header('Content-Type: application/json');
            echo json_encode($error);
        }
    }
    
    /**
     * provede inicializaci zakladni konfigurace
     * @var ContainerBuilder $builder
     */
    protected function initConfig($builder) {
        $configDir  = $this->getAbsoluteConfigDir();
        
        // nacte zakladni konfiguraci
        $builder->addDefinitions($configDir ."/" . $this->configFilePrefix . ".php");
        
        // nacte specificke konfigurace podle MACHINE_ID
        if (getenv($this->machineIdKey) != '') {
            $machineinfo = explode('-', getenv($this->machineIdKey));
            for ($i = count($machineinfo); $i > 0; $i--) {
                $tmp = '';
                for ($j = 0; $j < $i; $j++) {
                    $tmp.='-' . $machineinfo[$j];
                }
                $filePath = $configDir ."/". $this->configFilePrefix . $tmp . '.php';
                if (file_exists($filePath)) {
                    // nacte specifickou konfiguraci
                    $builder->addDefinitions($filePath);
                    break;
                }
            }
        }
        
        // TODO: potom vylepsit nejak elegantneji
        // nacist konfigurace modulu
        $moduesDir = $this->getBaseDir() ."/modules";
        foreach( scandir($moduesDir) as $moduleDir ) {
            $configFileDir = $moduesDir ."/". $moduleDir ."/config.php";
            if( file_exists($configFileDir) ) { // TODO: resit ze modul nema konfig
                $builder->addDefinitions($configFileDir);
            }
        }
    }
    
    protected function getBaseDir() {
        return $this->baseDir;
    }

    /**
     * vrati absolutni odkaz do nofiguracniho souboru
     * @return string
     */
    protected function getAbsoluteConfigDir() {
        return $this->baseDir . $this->configDir;
    }
}
